<?php
function penci_player_rankings_country_list( $code = '' ) {
	$isoCountries = [
		'AF' => 'Afghanistan',
		'AX' => 'Åland Islands',
		'AL' => 'Albania',
		'DZ' => 'Algeria',
		'AS' => 'American Samoa',
		'AD' => 'Andorra',
		'AO' => 'Angola',
		'AI' => 'Anguilla',
		'AQ' => 'Antarctica',
		'AG' => 'Antigua and Barbuda',
		'AR' => 'Argentina',
		'AM' => 'Armenia',
		'AW' => 'Aruba',
		'AU' => 'Australia',
		'AT' => 'Austria',
		'AZ' => 'Azerbaijan',
		'BS' => 'Bahamas',
		'BH' => 'Bahrain',
		'BD' => 'Bangladesh',
		'BB' => 'Barbados',
		'BY' => 'Belarus',
		'BE' => 'Belgium',
		'BZ' => 'Belize',
		'BJ' => 'Benin',
		'BM' => 'Bermuda',
		'BT' => 'Bhutan',
		'BO' => 'Bolivia',
		'BQ' => 'Bonaire, Sint Eustatius and Saba',
		'BA' => 'Bosnia and Herzegovina',
		'BW' => 'Botswana',
		'BV' => 'Bouvet Island',
		'BR' => 'Brazil',
		'IO' => 'British Indian Ocean Territory',
		'BN' => 'Brunei Darussalam',
		'BG' => 'Bulgaria',
		'BF' => 'Burkina Faso',
		'BI' => 'Burundi',
		'CV' => 'Cabo Verde',
		'KH' => 'Cambodia',
		'CM' => 'Cameroon',
		'CA' => 'Canada',
		'KY' => 'Cayman Islands',
		'CF' => 'Central African Republic',
		'TD' => 'Chad',
		'CL' => 'Chile',
		'CN' => 'China',
		'CX' => 'Christmas Island',
		'CC' => 'Cocos (Keeling) Islands',
		'CO' => 'Colombia',
		'KM' => 'Comoros',
		'CG' => 'Congo',
		'CD' => 'Congo, Democratic Republic of the',
		'CK' => 'Cook Islands',
		'CR' => 'Costa Rica',
		'CI' => "Côte d'Ivoire",
		'HR' => 'Croatia',
		'CU' => 'Cuba',
		'CW' => 'Curaçao',
		'CY' => 'Cyprus',
		'CZ' => 'Czechia',
		'DK' => 'Denmark',
		'DJ' => 'Djibouti',
		'DM' => 'Dominica',
		'DO' => 'Dominican Republic',
		'EC' => 'Ecuador',
		'EG' => 'Egypt',
		'SV' => 'El Salvador',
		'GQ' => 'Equatorial Guinea',
		'ER' => 'Eritrea',
		'EE' => 'Estonia',
		'SZ' => 'Eswatini',
		'ET' => 'Ethiopia',
		'FK' => 'Falkland Islands (Malvinas)',
		'FO' => 'Faroe Islands',
		'FJ' => 'Fiji',
		'FI' => 'Finland',
		'FR' => 'France',
		'GF' => 'French Guiana',
		'PF' => 'French Polynesia',
		'TF' => 'French Southern Territories',
		'GA' => 'Gabon',
		'GM' => 'Gambia',
		'GE' => 'Georgia',
		'DE' => 'Germany',
		'GH' => 'Ghana',
		'GI' => 'Gibraltar',
		'GR' => 'Greece',
		'GL' => 'Greenland',
		'GD' => 'Grenada',
		'GP' => 'Guadeloupe',
		'GU' => 'Guam',
		'GT' => 'Guatemala',
		'GG' => 'Guernsey',
		'GN' => 'Guinea',
		'GW' => 'Guinea-Bissau',
		'GY' => 'Guyana',
		'HT' => 'Haiti',
		'HM' => 'Heard Island and McDonald Islands',
		'VA' => 'Holy See',
		'HN' => 'Honduras',
		'HK' => 'Hong Kong',
		'HU' => 'Hungary',
		'IS' => 'Iceland',
		'IN' => 'India',
		'ID' => 'Indonesia',
		'IR' => 'Iran',
		'IQ' => 'Iraq',
		'IE' => 'Ireland',
		'IM' => 'Isle of Man',
		'IL' => 'Israel',
		'IT' => 'Italy',
		'JM' => 'Jamaica',
		'JP' => 'Japan',
		'JE' => 'Jersey',
		'JO' => 'Jordan',
		'KZ' => 'Kazakhstan',
		'KE' => 'Kenya',
		'KI' => 'Kiribati',
		'KP' => 'Korea (Democratic People\'s Republic of)',
		'KR' => 'Korea (Republic of)',
		'KW' => 'Kuwait',
		'KG' => 'Kyrgyzstan',
		'LA' => 'Lao People\'s Democratic Republic',
		'LV' => 'Latvia',
		'LB' => 'Lebanon',
		'LS' => 'Lesotho',
		'LR' => 'Liberia',
		'LY' => 'Libya',
		'LI' => 'Liechtenstein',
		'LT' => 'Lithuania',
		'LU' => 'Luxembourg',
		'MO' => 'Macao',
		'MG' => 'Madagascar',
		'MW' => 'Malawi',
		'MY' => 'Malaysia',
		'MV' => 'Maldives',
		'ML' => 'Mali',
		'MT' => 'Malta',
		'MH' => 'Marshall Islands',
		'MQ' => 'Martinique',
		'MR' => 'Mauritania',
		'MU' => 'Mauritius',
		'YT' => 'Mayotte',
		'MX' => 'Mexico',
		'FM' => 'Micronesia',
		'MD' => 'Moldova',
		'MC' => 'Monaco',
		'MN' => 'Mongolia',
		'ME' => 'Montenegro',
		'MS' => 'Montserrat',
		'MA' => 'Morocco',
		'MZ' => 'Mozambique',
		'MM' => 'Myanmar',
		'NA' => 'Namibia',
		'NR' => 'Nauru',
		'NP' => 'Nepal',
		'NL' => 'Netherlands',
		'NC' => 'New Caledonia',
		'NZ' => 'New Zealand',
		'NI' => 'Nicaragua',
		'NE' => 'Niger',
		'NG' => 'Nigeria',
		'NU' => 'Niue',
		'NF' => 'Norfolk Island',
		'MK' => 'North Macedonia',
		'MP' => 'Northern Mariana Islands',
		'NO' => 'Norway',
		'OM' => 'Oman',
		'PK' => 'Pakistan',
		'PW' => 'Palau',
		'PS' => 'Palestine',
		'PA' => 'Panama',
		'PG' => 'Papua New Guinea',
		'PY' => 'Paraguay',
		'PE' => 'Peru',
		'PH' => 'Philippines',
		'PN' => 'Pitcairn',
		'PL' => 'Poland',
		'PT' => 'Portugal',
		'PR' => 'Puerto Rico',
		'QA' => 'Qatar',
		'RE' => 'Réunion',
		'RO' => 'Romania',
		'RU' => 'Russian Federation',
		'RW' => 'Rwanda',
		'BL' => 'Saint Barthélemy',
		'SH' => 'Saint Helena, Ascension and Tristan da Cunha',
		'KN' => 'Saint Kitts and Nevis',
		'LC' => 'Saint Lucia',
		'MF' => 'Saint Martin (French part)',
		'PM' => 'Saint Pierre and Miquelon',
		'VC' => 'Saint Vincent and the Grenadines',
		'WS' => 'Samoa',
		'SM' => 'San Marino',
		'ST' => 'Sao Tome and Principe',
		'SA' => 'Saudi Arabia',
		'SN' => 'Senegal',
		'RS' => 'Serbia',
		'SC' => 'Seychelles',
		'SL' => 'Sierra Leone',
		'SG' => 'Singapore',
		'SX' => 'Sint Maarten (Dutch part)',
		'SK' => 'Slovakia',
		'SI' => 'Slovenia',
		'SB' => 'Solomon Islands',
		'SO' => 'Somalia',
		'ZA' => 'South Africa',
		'GS' => 'South Georgia and the South Sandwich Islands',
		'SS' => 'South Sudan',
		'ES' => 'Spain',
		'LK' => 'Sri Lanka',
		'SD' => 'Sudan',
		'SR' => 'Suriname',
		'SJ' => 'Svalbard and Jan Mayen',
		'SE' => 'Sweden',
		'CH' => 'Switzerland',
		'SY' => 'Syrian Arab Republic',
		'TW' => 'Taiwan',
		'TJ' => 'Tajikistan',
		'TZ' => 'Tanzania',
		'TH' => 'Thailand',
		'TL' => 'Timor-Leste',
		'TG' => 'Togo',
		'TK' => 'Tokelau',
		'TO' => 'Tonga',
		'TT' => 'Trinidad and Tobago',
		'TN' => 'Tunisia',
		'TR' => 'Türkiye',
		'TM' => 'Turkmenistan',
		'TC' => 'Turks and Caicos Islands',
		'TV' => 'Tuvalu',
		'UG' => 'Uganda',
		'UA' => 'Ukraine',
		'AE' => 'United Arab Emirates',
		'GB' => 'United Kingdom',
		'US' => 'United States of America',
		'UM' => 'United States Minor Outlying Islands',
		'UY' => 'Uruguay',
		'UZ' => 'Uzbekistan',
		'VU' => 'Vanuatu',
		'VE' => 'Venezuela',
		'VN' => 'Viet Nam',
		'VG' => 'Virgin Islands (British)',
		'VI' => 'Virgin Islands (U.S.)',
		'WF' => 'Wallis and Futuna',
		'EH' => 'Western Sahara',
		'YE' => 'Yemen',
		'ZM' => 'Zambia',
		'ZW' => 'Zimbabwe',
	];

	if ( $code ) {
		return isset( $isoCountries[ $code ] ) ? $isoCountries[ $code ] : '';
	}


	return $isoCountries;
}

function penci_player_rankings_default_texts() {
	return array(
		'prize'           => esc_html__( 'Prize Fund', 'penci-player-rankings' ),
		'related_matches' => esc_html__( 'Related Matches', 'penci-player-rankings' ),
		'fname'           => __( 'First Name', 'penci-player-rankings' ),
		'lname'           => __( 'Last Name', 'penci-player-rankings' ),
		'alias'           => __( 'Alias', 'penci-player-rankings' ),
		'country'         => __( 'Country', 'penci-player-rankings' ),
		'hometown'        => __( 'Hometown', 'penci-player-rankings' ),
		'birthday'        => __( 'Birthday', 'penci-player-rankings' ),
		'height'          => __( 'Height', 'penci-player-rankings' ),
		'match_location'  => __( 'Location', 'penci-player-rankings' ),
		'match_prize'     => __( 'Prize', 'penci-player-rankings' ),
		'match_date'      => __( 'From', 'penci-player-rankings' ),
		'match_date_to'   => __( 'To', 'penci-player-rankings' ),
		'all'             => __( 'All', 'penci-player-rankings' ),
		'past'            => __( 'Past', 'penci-player-rankings' ),
		'upcoming'        => __( 'Upcoming', 'penci-player-rankings' ),
		'status'          => __( 'Status', 'penci-player-rankings' ),
		'no_result'       => __( 'There are no results for your current selection.', 'penci-player-rankings' ),
		'na'       		  => __( 'N/A', 'penci-player-rankings' ),
	);
}

function penci_player_rankings_texts( $id ) {
	$texts = penci_player_rankings_default_texts();

	$mod_text = get_theme_mod( 'penci_player_rankings_text_' . $id );

	$default_text = isset( $texts[ $id ] ) ? $texts[ $id ] : '';

	return $mod_text ? $mod_text : $default_text;
}

function penci_player_rankings_df_ava() {
	return '<svg width="100%" height="100%" version="1.0" viewBox="0 0 3e3 3e3" xmlns="http://www.w3.org/2000/svg"><g transform="translate(0 3e3) scale(.1 -.1)"><path d="m13765 28734c-262-31-528-90-790-175-149-48-206-75-128-61 21 4 63 7 93 7 42 0 55-4 58-16 7-35-147-103-348-154-351-89-585-201-840-406-63-50-141-110-174-131-88-61-248-133-371-169-149-43-287-105-473-211-87-50-160-93-164-96-4-4 84-7 195-7 151 0 208-3 226-13 33-20 18-29-85-51-84-19-144-25-494-51-325-25-515-90-725-250-202-154-353-327-445-510l-32-64 48 42c101 88 181 151 254 200 74 49 149 86 157 78 3-2-37-44-89-93-364-343-530-537-658-768-39-71-39-71 79 67 190 224 329 350 483 438 40 24 125 73 188 111 113 67 221 121 270 134l25 7-25-24c-14-13-54-44-90-70-36-25-109-84-164-129-162-138-212-168-169-103l18 29-35-25c-190-135-324-286-410-465-63-130-72-166-22-90 40 63 94 115 118 115 10 0 14-12 14-43 0-51-35-126-82-177-18-20-53-58-77-85-50-57-279-302-359-385-205-212-399-517-532-836-95-228-111-424-49-611 26-80 44-94 36-27-19 147-20 213-3 259 29 75 36 65 60-84 14-88 18-97 55-135 23-23 41-50 41-61 0-10-27-98-59-194-74-222-138-451-195-702-25-110-57-224-74-261-50-110-122-176-246-223-52-20-56-24-30-25 43 0 130-27 149-46 22-22 19-87-9-195-58-225-60-382-8-501l18-42-4 100c-5 133 16 253 64 354 20 44 45 87 54 95 17 15 20 10 50-82 67-202 142-345 219-417 40-38 39-31-4 43-73 125-135 290-135 360 1 51 31 112 86 171 58 62 160 140 182 140s102-96 102-121c0-10-9-52-20-92-71-259-77-543-19-955 11-78 22-149 25-157 16-40 24-5 24 98 0 109 12 187 30 187 9 0 14-33 35-245 26-256 45-361 115-645 124-498 147-628 157-895 7-209 1-233-73-317-143-164-169-341-89-598 69-222 91-367 104-710 11-261 24-344 81-524 88-278 146-503 215-834 65-310 157-559 346-932 182-359 225-420 334-471 82-39 151-39 265 1 46 17 94 30 106 30 62 0 104-136 144-465 66-541 92-714 146-960 97-434 226-738 447-1049 38-54 77-119 85-145 14-39 17-131 20-624 2-402 0-595-8-632-17-82-65-168-119-217-51-45-64-53-204-117-108-49-199-120-258-200-24-34-88-148-142-254-326-637-752-1230-1227-1708-317-319-586-534-925-739-274-166-518-280-890-415-636-231-934-357-1475-620-663-323-1028-463-1605-617-628-166-1171-402-1635-711-351-233-643-478-1009-847-211-212-300-314-374-425-120-181-167-304-222-571-86-420-203-811-353-1184-75-186-129-305-250-547-125-250-171-360-215-520-28-102-33-113-54-113h-23v-680-680h15000 15000v709 709l-51 119c-152 352-226 567-289 840-61 266-128 455-236 672-51 102-131 242-176 311-109 166-1099 1483-1224 1629-133 155-326 327-509 453-232 161-596 339-1215 596-331 138-438 184-720 309-124 56-344 151-490 213-698 295-945 404-1305 574-141 67-205 89-550 191-390 116-743 264-1051 440-54 32-220 137-369 235-287 188-547 354-973 620-353 221-403 271-493 496-144 359-420 707-1114 1400-281 281-357 363-383 412-66 124-63 98-67 662-2 302 0 548 6 595 25 204 103 414 234 635 252 424 363 852 445 1725 11 121 25 243 30 270 15 76 59 202 76 216 12 10 34 9 107-4 116-21 169-21 238-1 67 20 109 51 151 111 17 26 90 171 161 323 286 610 354 797 417 1146 93 514 139 723 269 1226 139 538 176 738 169 909-4 93-8 113-37 175-36 77-88 136-173 196-64 45-98 101-98 161 0 20 13 96 30 169 40 182 47 236 60 438 17 294 48 426 140 615 66 134 85 249 84 500 0 202-22 355-76 542-16 58-27 107-24 110 6 7 54-27 88-64 14-15 44-61 66-102l40-74 7 58c4 32 5 113 2 179-5 117-13 156-70 351-17 58-21 99-21 245 0 162 3 194 43 435 25 143 48 264 52 269 17 19 62-149 100-374 28-161 36-147 38 66 1 185-13 358-49 584-49 307-53 388-34 595 57 617-92 1124-473 1601-101 126-276 304-413 419-152 128-220 202-289 312-109 174-208 273-343 343-123 65-207 83-383 83-175 1-214-7-436-88-83-30-155-52-160-49s-9 42-9 87c0 103-24 262-51 347-20 62-88 204-95 198-1-2 20-78 48-168 96-313 73-466-94-627-65-61-180-129-200-117-15 9-2 105 27 207 57 196 98 516 84 662-13 151-59 263-185 451-261 390-633 662-1127 824-54 18-100 30-103 28-2-3 47-33 108-68 207-116 249-151 353-290 59-80 130-208 120-218-2-3-60 53-127 123-143 149-301 288-428 375-89 61-102 74-77 83 16 6 6 10-143 46-164 40-300 61-380 60s-66-6 140-49c120-26 164-40 255-85 107-53 244-144 322-215 37-33 37-35 14-38-13-2-49 10-80 26-319 168-446 220-631 258-113 24-358 24-490 1-206-37-429-15-653 63-62 21-132 44-157 50-52 14-110 54-110 77 0 13 8 15 48 10 26-4 71-9 100-13 93-12 58 12-85 59-226 74-340 102-574 138-176 28-631 35-814 13z"/></g></svg>';
}

function penci_player_single_ranking() {
	$ranking_number = penci_player_rankings_texts( 'na' );
	$current_id     = get_the_ID();

	$ranking = get_post_meta( $current_id, 'pencibm_ranking', true );

	if ( $ranking && $ranking !== '' ) {
		return $ranking;
	}

	// Get current post ID and ranking

	$args = [
		'post_type'      => get_post_type(),
		'posts_per_page' => - 1,
		'orderby'        => 'meta_value_num',
		'meta_key'       => 'pencibm_ranking',
		'order'          => 'ASC',
		'fields'         => 'ids', // Only return post IDs to optimize
	];

	$current_terms = get_the_terms( $current_id, 'player_team' );
	
	if ( $current_terms && ! is_wp_error( $current_terms ) ) {
		// Use the first term (or loop if needed for multiple)
		$term_id = $current_terms[0]->term_id;

		// Get all posts in this term, ordered by pencibm_ranking
		$args['tax_query'] = [
			[
				'taxonomy' => 'player_team',
				'field'    => 'term_id',
				'terms'    => $term_id,
			],
		];
	}

	$ranked_posts = get_posts( $args );

	// Find the current post's position
	$position = array_search( $current_id, $ranked_posts );

	if ( $position !== false ) {
		$ranking_number = $position + 1; // Position is zero-based
	}

	return $ranking_number;
}