<?php

class PenciPlayerRankings_Metabox_Class {

	/**
	 * Hook into the appropriate actions when the class is constructed.
	 */
	public function __construct() {
		add_action( 'add_meta_boxes', array( $this, 'add_player_meta_box' ) );
		add_action( 'save_post', array( $this, 'save' ) );
	}

	/**
	 * Adds the meta box container.
	 */
	public function add_player_meta_box( $post_type ) {

		if ( in_array( $post_type, array( 'player' ) ) ) {
			add_meta_box(
				'penci_player_rankings_meta'
				, esc_html__( 'Player Informations', 'penci-player-rankings' )
				, array( $this, 'render_meta_box_content' )
				, $post_type
				, 'advanced'
				, 'default'
			);
		}
	}

	/**
	 * Save the meta when the post is saved.
	 *
	 * @param int $post_id The ID of the post being saved.
	 */
	public function save( $post_id ) {

		/*
		 * We need to verify this came from the our screen and with proper authorization,
		 * because save_post can be triggered at other times.
		 */

		// Check if our nonce is set.
		if ( ! isset( $_POST['penci_player_rankings_custom_box_nonce'] ) ) {
			return $post_id;
		}

		$nonce = $_POST['penci_player_rankings_custom_box_nonce'];

		// Verify that the nonce is valid.
		if ( ! wp_verify_nonce( $nonce, 'penci_player_rankings_custom_box' ) ) {
			return $post_id;
		}

		// If this is an autosave, our form has not been submitted,
		//     so we don't want to do anything.
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return $post_id;
		}

		// Check the user's permissions.
		if ( ! current_user_can( 'edit_post', $post_id ) ) {
			return $post_id;
		}

		$options = [
			'pencibm_lname',
			'pencibm_fname',
			'pencibm_alias',
			'pencibm_country',
			'pencibm_hometown',
			'pencibm_birthday',
			'pencibm_height',
			'pencibm_user_fields',
			'pencibm_ranking',
		];

		foreach ( $options as $option ) {
			if ( isset( $_POST[ $option ] ) ) {
				update_post_meta( $post_id, $option, $_POST[ $option ] );
			}
		}
	}

	/**
	 * Render Meta Box content.
	 *
	 * @param WP_Post $post The post object.
	 */
	public function render_meta_box_content( $post ) {

		// Add an nonce field so we can check for it later.
		wp_nonce_field( 'penci_player_rankings_custom_box', 'penci_player_rankings_custom_box_nonce' );

		$pencibm_user_fields = get_post_meta( $post->ID, 'pencibm_user_fields', true );

		$default_metas = [
			'fname'    => __( 'First Name', 'penci-player-rankings' ),
			'lname'    => __( 'Last Name', 'penci-player-rankings' ),
			'alias'    => __( 'Alias', 'penci-player-rankings' ),
			'country'  => __( 'Country', 'penci-player-rankings' ),
			'hometown' => __( 'Hometown', 'penci-player-rankings' ),
			'birthday' => __( 'Birthday', 'penci-player-rankings' ),
			'height'   => __( 'Height', 'penci-player-rankings' ),
			'ranking'  => __( 'Custom Ranking', 'penci-player-rankings' ),
		];
		?>

        <div class="penci-table-meta">

			<?php
			foreach ( $default_metas as $meta_id => $meta_name ) {
				$meta_id    = 'pencibm_' . $meta_id;
				$meta_value = get_post_meta( $post->ID, $meta_id, true );
				?>

                <div class="pcmt-control-wrapper">
                    <div class="pcmt-title">
                        <label style="color: #000;font-weight: 600; font-size: 14px; padding-left: 0;"
                               for="video_preview_url"
                               class="penci-format-row"><?php echo $meta_name; ?></label>

                    </div>
                    <div class="pcmt-control">

						<?php if ( $meta_id == 'pencibm_country' ) {
							$country_options = penci_player_rankings_country_list();
							?>

                            <select style="width:100%;" type="text" name="<?php echo $meta_id; ?>"
                                    id="<?php echo $meta_id; ?>"
                                    value="<?php echo $meta_value; ?>">
                                <option value=""><?php echo esc_html__( 'Select Country', 'penci-player-rankings' ); ?></option>
								<?php foreach ( $country_options as $key => $value ) { ?>
                                    <option value="<?php echo esc_attr( $key ); ?>" <?php selected( $meta_value, $key ); ?>>
										<?php echo esc_html( $value ); ?></option>
								<?php } ?>
                            </select>

						<?php } else { ?>

                            <input style="width:100%;" type="text" name="<?php echo $meta_id; ?>"
                                   id="<?php echo $meta_id; ?>"
                                   value="<?php echo $meta_value; ?>">
						<?php } ?>


                    </div>
                </div>

				<?php
			}
			?>

            <div class="pcmt-control-wrapper">
                <div class="pcmt-title">
                    <h2 style="font-weight: 600; font-size: 14px; padding-left: 0;"><?php _e( 'Other Information', 'soledad' ); ?></h2>
                </div>
                <div class="pcmt-control" style="flex-direction: column;">
                    <div class="pcmt-child-control" style="width: 100%;">
                        <label for="pencibm_user_fields"
                               style="font-weightl:bold;display:block;margin-bottom:10px;"><?php _e( 'Add new user information.', 'soledad' ); ?></label>


                        <div class="pc-meta-repeater" id="pencibm-user-fields-wrapper">
                            <!-- Repeater Item Template (Hidden) -->
                            <div class="pc-meta-repeater-item-content pc-repeater-template" style="display: none;">
                                <div class="pc-meta-repeater-input">
                                    <label><?php _e( 'Name', 'soledad' ); ?></label>
                                    <input type="text" name="" class="penci-bmfield-name" value="">
                                </div>
                                <div class="pc-meta-repeater-input">
                                    <label><?php _e( 'Value', 'soledad' ); ?></label>
                                    <input type="text" name="" class="penci-bmfield-value" value="">
                                </div>
                                <a href="#" class="pc-meta-repeater-item-remove"><?php _e( 'Remove', 'soledad' ); ?></a>
                            </div>

                            <!-- Repeater Items Container -->
                            <div class="pc-meta-repeater-items">
								<?php if ( $pencibm_user_fields ):
									foreach ( $pencibm_user_fields as $index => $source ): ?>
                                        <div class="pc-meta-repeater-item-content">
                                            <div class="pc-meta-repeater-input">
                                                <label><?php _e( 'Name', 'soledad' ); ?></label>
                                                <input type="text"
                                                       name="pencibm_user_fields[<?php echo $index; ?>][name]"
                                                       class="penci-bmfield-name"
                                                       value="<?php echo $source['name']; ?>">
                                            </div>
                                            <div class="pc-meta-repeater-input">
                                                <label><?php _e( 'Value', 'soledad' ); ?></label>
                                                <input type="text"
                                                       name="pencibm_user_fields[<?php echo $index; ?>][url]"
                                                       class="penci-bmfield-value"
                                                       value="<?php echo $source['url']; ?>">
                                            </div>
                                            <a href="#"
                                               class="pc-meta-repeater-item-remove"><?php _e( 'Remove', 'soledad' ); ?></a>
                                        </div>
									<?php endforeach;
								endif;
								?>
                            </div>

                            <!-- Add Button -->
                            <div class="pc-meta-repeater-item-actions">
                                <button type="button"
                                        class="button pc-meta-repeater-item-add"><?php _e( 'Add new meta', 'soledad' ); ?></button>
                            </div>
                        </div>

                        <!-- jQuery Script -->
                        <script>
                          jQuery(document).ready(function ($) {
                            function updateRepeaterInputNames () {
                              $('#pencibm-user-fields-wrapper .pc-meta-repeater-items .pc-meta-repeater-item-content').
                                each(function (index) {
                                  $(this).
                                    find('.penci-bmfield-name').
                                    attr('name', 'pencibm_user_fields[' + index + '][name]')
                                  $(this).
                                    find('.penci-bmfield-value').
                                    attr('name', 'pencibm_user_fields[' + index + '][url]')
                                })
                            }

                            // Add new item
                            $('.pc-meta-repeater-item-add').on('click', function (e) {
                              e.preventDefault()
                              var $template = $('.pc-repeater-template').
                                clone().
                                removeClass('pc-repeater-template').
                                show()
                              $('.pc-meta-repeater-items').append($template)
                              updateRepeaterInputNames()
                            })

                            // Remove item
                            $('#pencibm-user-fields-wrapper').
                              on('click', '.pc-meta-repeater-item-remove', function (e) {
                                e.preventDefault()
                                $(this).closest('.pc-meta-repeater-item-content').remove()
                                updateRepeaterInputNames()
                              })
                          })
                        </script>

                    </div>
                </div>
            </div>

        </div>
		<?php

	}
}

/**
 * Adds Penci review meta box to the post editing screen
 */
function Penci_Player_Rankings_Add_Custom_Metabox() {
	new PenciPlayerRankings_Metabox_Class();
}

if ( is_admin() ) {
	add_action( 'load-post.php', 'Penci_Player_Rankings_Add_Custom_Metabox' );
	add_action( 'load-post-new.php', 'Penci_Player_Rankings_Add_Custom_Metabox' );
}