<?php
$matches = \Penci_Football_API::get( [
    'token'  => $settings['token'],
    'type'   => 'matches',
    'league' => $settings['league'],
    'query'  => [
        'status' => $settings['status'],
    ],
] );
$date_format = isset( $settings['date_format'] ) ? $settings['date_format'] : 'Y/m/d - H:i';
$style = isset( $settings['style'] ) ? $settings['style'] : 'style-1';
if ( ! empty( $matches['matches'] ) ) :
    $matches_data = array_slice( $matches['matches'], 0, $settings['limit'] );
    ?>
    <div class="penci-football-matches-wrap">
        <div class="penci-football-matches <?php echo $style; ?>">
            <?php foreach ( $matches_data as $index => $match ): 
                $is_result = ! empty( $match['score']['fullTime'] ) && isset( $match['score']['fullTime']['home'] ) && isset( $match['score']['fullTime']['away'] );
                ?>
                <div class="penci-football-match">

                <?php if ( 'style-2' == $style ) : ?>
                    <div class="penci-matche-time">
                        <time datetime="<?php echo $match['utcDate']; ?>"><?php echo penci_sport_mtime( $match['utcDate'], $date_format ); ?></time>
                    </div>
                <?php endif; ?>

                    <div class="pcfm-item pcfm-home">
                        <div class="pcfm-item-logo">
                            <img src="<?php echo $match['homeTeam']['crest']; ?>"
                                 alt="<?php echo $match['homeTeam']['shortName']; ?>">
                        </div>
                        <h4 class="pcfm-item-title">
                            <?php echo 'style-2' == $style ? $match['homeTeam']['tla'] : $match['homeTeam']['shortName']; ?>
                        </h4>
                        <?php if ( 'style-2' == $style ): 
                            $home_score = $is_result ? $match['score']['fullTime']['home'] : '-';
                            ?>
                        <div class="penci-matche-score inline-score">
                            <span class="home">
                                <?php echo $home_score; ?>
                            </span>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php if ( $is_result && 'style-1' == $style ): ?>
                        <div class="penci-matche-score">
                            <span class="home"><?php echo $match['score']['fullTime']['home']; ?></span>
                            <span class="away"><?php echo $match['score']['fullTime']['away']; ?></span>
                        </div>
                    <?php elseif ( 'style-1' == $style ): ?>
                        <div class="penci-matche-time">
                            <time datetime="<?php echo $match['utcDate']; ?>"><?php echo penci_sport_mtime( $match['utcDate'], $date_format ); ?></time>
                        </div>
                    <?php endif; ?>
                    <div class="pcfm-item pcfm-away">
                        <div class="pcfm-item-logo">
                            <img src="<?php echo $match['awayTeam']['crest']; ?>"
                                 alt="<?php echo $match['awayTeam']['shortName']; ?>">
                        </div>
                        <h4 class="pcfm-item-title">
                            <?php echo 'style-2' == $style ? $match['awayTeam']['tla'] : $match['awayTeam']['shortName']; ?>
                        </h4>
                        <?php if ( 'style-2' == $style ): 
                                $away_score = $is_result ? $match['score']['fullTime']['away'] : '-';
                            ?>
                        <div class="penci-matche-score inline-score">
                            <span class="away"><?php echo $away_score; ?></span>
                        </div>
                        <?php endif; ?>
                    </div>

                </div>
            <?php endforeach; ?>
        </div>
    </div>
<?php
endif;