; (function ($) {
  "use strict";

  var WidgetDefault = function ($scope, $) {

    var windowOn = $(window);
    /* -----------------------------------------------------
       Sicky Header
     ----------------------------------------------------- */
    windowOn.on('scroll', function () {
      var scroll = $(window).scrollTop();
      if (scroll < 100) {
        $("#sw-header-sticky").removeClass("sw-header-sticky");
      } else {
        $("#sw-header-sticky").addClass("sw-header-sticky");
      }
    });

    /* -----------------------------------------------------
  Counter 
----------------------------------------------------- */
    if ($(".sw-count-box").length) {
      $(".sw-count-box").appear(
        function () {
          var $t = $(this),
            n = $t.find(".sw-count-number").attr("data-stop"),
            r = parseInt($t.find(".sw-count-number").attr("data-speed"), 10);

          if (!$t.hasClass("counted")) {
            $t.addClass("counted");
            $({
              countNum: $t.find(".sw-count-number").text()
            }).animate(
              {
                countNum: n
              },
              {
                duration: r,
                easing: "linear",
                step: function () {
                  $t.find(".sw-count-number").text(Math.floor(this.countNum));
                },
                complete: function () {
                  $t.find(".sw-count-number").text(this.countNum);
                }
              }
            );
          }
        },
        {
          accY: 0
        }
      );
    }
    // owl slider
    let swiftcartowlCarousel = $(".swiftcart-owl__carousel");
    if (swiftcartowlCarousel.length) {
      swiftcartowlCarousel.each(function () {
        let elm = $(this);
        let options = elm.data("owl-options");
        let thmOwlCarousel = elm.owlCarousel(
          "object" === typeof options ? options : JSON.parse(options)
        );
        elm.find("button").each(function () {
          $(this).attr("aria-label", "carousel button");
        });
      });
    }

    let swiftcartowlCarouselNav = $(".swiftcart-owl__carousel--custom-nav");
    if (swiftcartowlCarouselNav.length) {
      swiftcartowlCarouselNav.each(function () {
        let elm = $(this);
        let owlNavPrev = elm.data("owl-nav-prev");
        let owlNavNext = elm.data("owl-nav-next");
        $(owlNavPrev).on("click", function (e) {
          elm.trigger("prev.owl.carousel");
          e.preventDefault();
        });

        $(owlNavNext).on("click", function (e) {
          elm.trigger("next.owl.carousel");
          e.preventDefault();
        });
      });
    }

    let swiftcartowlCarouselWithCounter = $(".swiftcart-owl__carousel--with-counter");
    if (swiftcartowlCarouselWithCounter.length) {
      swiftcartowlCarouselWithCounter.each(function () {
        let elm = $(this);
        let options = elm.data("owl-options");

        function addLeadingZero(num, size) {
          num = num.toString();
          while (num.length < size) num = "0" + num;
          return num;
        }
        elm
          .on("initialized.owl.carousel", function (event) {
            var idx = event.item.index;
            var carousel = event.relatedTarget;
            var carouselCount = carousel.items().length;

            if (!event.namespace) {
              return;
            }

            elm.append(
              '<div class="swiftcart-owl__carousel__counter"><span class="swiftcart-owl__carousel__counter__current"></span> / <span class="swiftcart-owl__carousel__counter__total"></span></div>'
            );
            elm
              .find(".swiftcart-owl__carousel__counter__current")
              .text(
                addLeadingZero(carousel.relative(carousel.current()) + 1, 2)
              );
            elm
              .find(".swiftcart-owl__carousel__counter__total")
              .text(addLeadingZero(carouselCount, 2));
          })
          .owlCarousel(
            "object" === typeof options ? options : JSON.parse(options)
          )
          .on("changed.owl.carousel", function (event) {
            var carousel = event.relatedTarget;
            elm
              .find(".swiftcart-owl__carousel__counter__current")
              .text(
                addLeadingZero(carousel.relative(carousel.current()) + 1, 2)
              );
          });
      });
    }

    /* -----------------------------------------------------
  Tab
----------------------------------------------------- */
    if ($(".tabs-box").length) {
      $(".tabs-box .tab-buttons .tab-btn").on("click", function (e) {
        e.preventDefault();
        var target = $($(this).attr("data-tab"));

        if ($(target).is(":visible")) {
          return false;
        } else {
          target
            .parents(".tabs-box")
            .find(".tab-buttons")
            .find(".tab-btn")
            .removeClass("active-btn");
          $(this).addClass("active-btn");
          target
            .parents(".tabs-box")
            .find(".tabs-content")
            .find(".tab")
            .fadeOut(0);
          target
            .parents(".tabs-box")
            .find(".tabs-content")
            .find(".tab")
            .removeClass("active-tab");
          $(target).fadeIn(300);
          $(target).addClass("active-tab");
        }
      });
    }

    // 05. Data CSS Js
    if ($("[data-bg]").length) {
      $("[data-bg]").each(function () {
        $(this).css("background-image", "url( " + $(this).attr("data-bg") + "  )");
        $(this).removeAttr("data-bg").addClass("background-image");
      });
    };
    // 06. Data CSS Js
    if ($("[data-bg-color]").length) {
      $("[data-bg-color]").each(function () {
        $(this).css("background-color", "" + $(this).attr('data-bg-color') + " ");
        $(this).removeAttr("data-bg-color").addClass("background-color");
      });
    };

    /* -----------------------------------------------------
  Accordion 
----------------------------------------------------- */
    if ($(".swiftcart-accordion-active").length) {
      var accordionGrp = $(".swiftcart-accordion-active");
      accordionGrp.each(function () {
        var accordionName = $(this).data("grp-name");
        var Self = $(this);
        var accordion = Self.find(".sw-accordion");
        Self.addClass(accordionName);
        Self.find(".sw-accordion .sw-accordion-content").hide();
        Self.find(".sw-accordion.active").find(".sw-accordion-content").show();
        accordion.each(function () {
          $(this)
            .find(".sw-accordion-title")
            .on("click", function () {
              if ($(this).parent().hasClass("active") === false) {
                $(".swiftcart-accordion-active." + accordionName)
                  .find(".sw-accordion")
                  .removeClass("active");
                $(".swiftcart-accordion-active." + accordionName)
                  .find(".sw-accordion")
                  .find(".sw-accordion-content")
                  .slideUp();
                $(this).parent().addClass("active");
                $(this).parent().find(".sw-accordion-content").slideDown();
              }
            });
        });
      });
    }




  };

  $(window).on("elementor/frontend/init", function () {
    elementorFrontend.hooks.addAction(
      "frontend/element_ready/widget",
      WidgetDefault
    );
  });
})(jQuery);
