<?php
/*
 * Theme Metabox Options
 * @package swiftcart
 * @since 1.0.0
 * */

if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}

if (class_exists('CSF')) {


    /*-------------------------------------
	   Page Options
   -------------------------------------*/
    $swiftcart_group_meta = 'swiftcart_event_meta';
    CSF::createMetabox($swiftcart_group_meta, array(
        'title'     => esc_html__('Event Meta', 'swiftcart-core'),
        'post_type' => 'event',
    ));

    //
    // Create a section
    CSF::createSection($swiftcart_group_meta, array(
        'title'  => esc_html__('Event Info', 'swiftcart-core'),
        'fields' => array(
            array(
                'id'       => 'event_location_name_link',
                'type'     => 'link',
                'title'    => esc_html__('Event Location', 'swiftcart-core'),
                'default'  => array(
                    'url'    => '#',
                    'text'   => 'Event Location',
                    'target' => '_blank'
                ),
            ),
            array(
                'id'    => 'location_icon',
                'type'  => 'icon',
                'title' => esc_html__('Event Location Icon', 'swiftcart-core'),
                'default' => 'fas fa-map-marker-alt'
            ),
            array(
                'id'    => 'time_icon',
                'type'  => 'icon',
                'title' => esc_html__('Event Time Icon', 'swiftcart-core'),
                'default' => 'far fa-calendar-times'
            )

        )
    ));
}//endif