<?php
/*
 * Theme Metabox Options
 * @package swiftcart
 * @since 1.0.0
 * */

if (!defined('ABSPATH')) {
	exit(); // exit if access directly
}

if (class_exists('CSF')) {


	$swiftcart_prefix = 'swiftcart';


	/*-------------------------------------
	   Page Options
   -------------------------------------*/
	$swiftcart_group_meta = 'swiftcart_page_meta';

	CSF::createMetabox($swiftcart_group_meta, array(
		'title'     => esc_html__('Page Options', 'swiftcart'),
		'post_type' => 'page',
	));


	//
	// Create a section
	CSF::createSection($swiftcart_group_meta, array(
		'title'  => esc_html__('Header Option', 'swiftcart'),
		'fields' => array(
			array(
				'id'         => 'enable_header_builder',
				'title'      => esc_html__('Enable Header Builder', 'swiftcart'),
				'type'       => 'switcher',
				'desc'       => esc_html__('You can set Yes / No to use header builder', 'swiftcart'),
				'default'    => false,
			),
			array(
				'id'          => 'header-builder-id',
				'type'        => 'select',
				'title'       => esc_html__('Select Header', 'swiftcart'),
				'placeholder' => esc_html__('Select a Header', 'swiftcart'),
				'options'     => swiftcart_get_header_builder_library(),
				'dependency'  => array('enable_header_builder', '==', true),
				'desc'        => esc_html__("You need to create first header from header builder", 'swiftcart')
			),
		)
	));

	//
	// breadcrumb
	CSF::createSection($swiftcart_group_meta, array(
		'title'  => esc_html__('Breadcrumb', 'swiftcart'),
		'fields' => array(
			array(
				'type'    => 'subheading',
				'content' => esc_html__('Breadcrumb', 'swiftcart'),
			),
			array(
				'id'      => $swiftcart_prefix . '_breadcrumb',
				'title'   => esc_html__('Breadcrumb', 'swiftcart'),
				'type'    => 'select',
				'options' => array(
					'show' => esc_html__('Show', 'swiftcart'),
					'hide' => esc_html__('Hide', 'swiftcart'),
				),
				'default' => 'show'
			),
		)

	));

	// Create a section
	CSF::createSection($swiftcart_group_meta, array(
		'title'  => esc_html__('Footer Option', 'swiftcart'),
		'fields' => array(
			array(
				'id'         => 'enable_footer_builder',
				'title'      => esc_html__('Enable Footer Builder', 'swiftcart'),
				'type'       => 'switcher',
				'desc'       => esc_html__('You can set Yes / No to use footer builder', 'swiftcart'),
				'default'    => false,
			),
			array(
				'id'          => 'footer-builder-id',
				'type'        => 'select',
				'title'       => esc_html__('Select Footer', 'swiftcart'),
				'placeholder' => esc_html__('Select a Footer', 'swiftcart'),
				'options'     => swiftcart_get_footer_builder_library(),
				'desc'        => esc_html__("You need to create first footer from footer builder", 'swiftcart'),
				'dependency'  => array('enable_footer_builder', '==', true)
			),
		)
	));

	//
	// main color
	CSF::createSection($swiftcart_group_meta, array(
		'title'  => esc_html__('Main Color', 'swiftcart-core'),
		'fields' => array(
			array(
				'type'    => 'subheading',
				'content' => esc_html__('Main Color', 'swiftcart-core'),
			),
			array(
				'id'      => 'main_color',
				'type'    => 'color',
				'title'   => esc_html__('Theme Main Color', 'swiftcart-core'),
				'desc'    => esc_html__('This is theme primary color, means it\'ll affect most of elements that have default color of our theme primary color', 'swiftcart-core')
			),
			array(
				'id'    => 'header_extra_class',
				'type'  => 'text',
				'title' => esc_html__('Add Home Class', 'swiftcart-core'),
				'desc'    => esc_html__('home-two class for color option', 'swiftcart-core')
			),
		)

	));

	$swiftcart_footer_meta = 'swiftcart_footer_meta';

	/*-------------------------------------
	   Footer Options
   -------------------------------------*/
	CSF::createMetabox($swiftcart_footer_meta, array(
		'title'     => esc_html__('Footer Options', 'swiftcart'),
		'post_type' => array('project', 'service', 'event')
	));


	// Create a section
	CSF::createSection($swiftcart_footer_meta, array(
		'title'  => esc_html__('Footer Option', 'swiftcart'),
		'fields' => array(
			array(
				'id'         => 'enable_footer_builder',
				'title'      => esc_html__('Enable Footer Builder', 'swiftcart'),
				'type'       => 'switcher',
				'desc'       => esc_html__('You can set Yes / No to use footer builder', 'swiftcart'),
				'default'    => false,
			),
			array(
				'id'          => 'footer-builder-id',
				'type'        => 'select',
				'title'       => esc_html__('Select Footer', 'swiftcart'),
				'placeholder' => esc_html__('Select a Footer', 'swiftcart'),
				'options'     => swiftcart_get_footer_builder_library(),
				'desc'        => esc_html__("You need to create first footer from footer builder", 'swiftcart'),
				'dependency'  => array('enable_footer_builder', '==', true)
			),
		)
	));
}//endif