<?php
/*
 * Theme Metabox Options
 * @package swiftcart
 * @since 1.0.0
 * */

if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}

if (class_exists('CSF')) {


    /*-------------------------------------
	   price Options
   -------------------------------------*/
    $swiftcart_group_meta = 'swiftcart_pricing_meta';
    CSF::createMetabox($swiftcart_group_meta, array(
        'title'     => esc_html__('Pricing Meta', 'swiftcart-core'),
        'post_type' => 'pricing',
    ));

    //
    // Create a section
    CSF::createSection($swiftcart_group_meta, array(
        'title'  => esc_html__('Pricing Info', 'swiftcart-core'),
        'fields' => array(
            array(
                'id'          => 'select_style',
                'type'        => 'select',
                'title'       => esc_html__('Style', 'swiftcart-core'),
                'options'     => array(
                    'style-one'  => 'Style One',
                    'style-two'  => 'Style Two',
                ),
                'default'     => 'style-one'
            ),
            array(
                'id'         => 'renewal_fee',
                'title'      => esc_html__('Renewal Fee ', 'swiftcart-core'),
                'type'       => 'text',
                'default'    => 40,
            ),
            array(
                'id'         => 'currency',
                'title'      => esc_html__(' Currency', 'swiftcart-core'),
                'type'       => 'text',
                'default'    => '$'
            ),
            array(
                'id'         => 'price_plan',
                'title'      => esc_html__(' Price Plan', 'swiftcart-core'),
                'type'       => 'text',
                'default'    => esc_html__('/ Mo', 'swiftcart-core'),
                'dependency' => array('select_style', '==', 'style-two'),
            ),
            array(
                'id'    => 'price_icon',
                'type'  => 'icon',
                'title' => esc_html__('Price Icon', 'swiftcart-core'),
            ),
            array(
                'id'         => 'tag_line',
                'title'      => esc_html__('Tag Line', 'swiftcart-core'),
                'type'       => 'text',
                'default'    => false,
                'default'    => esc_html__('per month billed annually', 'swiftcart-core'),
                'dependency' => array('select_style', '==', 'style-one'),
            ),
            array(
                'id'         => 'features',
                'type'       => 'repeater',
                'title'      => esc_html__('Features', 'swiftcart-core'),
                'fields'     => array(
                    array(
                        'id'    => 'features',
                        'type'  => 'text',
                        'title' => esc_html__('Add Features', 'swiftcart-core'),
                        'default' => esc_html__('30 Days Trial Features', 'swiftcart-core')
                    ),
                    array(
                        'id'    => 'activity',
                        'type'  => 'switcher',
                        'title' => esc_html__('Availability', 'swiftcart-core'),
                        'default' => true
                    ),

                ),
            ),
            array(
                'id'         => 'button_label',
                'title'      => esc_html__('Button Label', 'swiftcart-core'),
                'type'       => 'text',
                'default'    => false,
                'default'    => esc_html__('Get Started', 'swiftcart-core')
            ),
            array(
                'id'         => 'button_url',
                'title'      => esc_html__('Button Url', 'swiftcart-core'),
                'type'       => 'text',
                'default'    => false,
                'default'    => '#'
            ),
        )
    ));
}//endif