<?php
/*
 * Theme Metabox Options
 * @package swiftcart
 * @since 1.0.0
 * */

if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}

if (class_exists('CSF')) {


    /*-------------------------------------
	   Page Options
   -------------------------------------*/
    $swiftcart_group_meta = 'swiftcart_project_meta';
    CSF::createMetabox($swiftcart_group_meta, array(
        'title'     => esc_html__('Project Meta', 'swiftcart-core'),
        'post_type' => 'project',
    ));

    //
    // Create a section
    CSF::createSection($swiftcart_group_meta, array(
        'fields' => array(
            array(
                'id'         => 'project_info',
                'type'       => 'repeater',
                'title'      => esc_html__('Project Info', 'swiftcart-core'),
                'fields'     => array(
                    array(
                        'id'    => 'title',
                        'type'  => 'text',
                        'title' => esc_html__('Info Title', 'swiftcart-core'),
                        'default' => esc_html__('Project', 'swiftcart-core')
                    ),
                    array(
                        'id'    => 'content',
                        'type'  => 'text',
                        'title' => esc_html__('Info Content', 'swiftcart-core'),
                        'default' => esc_html__('It Solution Service', 'swiftcart-core')
                    ),
                ),
            ),
        )
    ));
}//endif