<?php
/*
 * Theme Metabox Options
 * @package swiftcart
 * @since 1.0.0
 * */

if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}

if (class_exists('CSF')) {


    /*-------------------------------------
	   Page Options
   -------------------------------------*/
    $swiftcart_group_meta = 'swiftcart_property_meta';
    CSF::createMetabox($swiftcart_group_meta, array(
        'title'     => esc_html__('Property Meta', 'swiftcart-core'),
        'post_type' => 'property',
    ));

    //
    // Create a section
    CSF::createSection($swiftcart_group_meta, array(
        'title'  => esc_html__('Property Info', 'swiftcart-core'),
        'fields' => array(
            array(
                'id'    => 'property_short_info',
                'type'  => 'textarea',
                'title' => esc_html__('Property Short Info', 'swiftcart-core'),
            ),
            array(
                'id'       => 'property_price',
                'type'     => 'text',
                'title'    => esc_html__('Property Price', 'swiftcart-core'),
                'placeholder' => "$100",
                
            ),
            array(
                'id'       => 'property_location_name',
                'type'     => 'text',
                'title'    => esc_html__('Property Location', 'swiftcart-core'),
                'placeholder' => "New York",
            ),
            array(
                'id'       => 'property_bedrooms',
                'type'     => 'number',
                'title'    => esc_html__('Bedroom', 'swiftcart-core'),
                'default' => 0,
            ),
            array(
                'id'       => 'property_bathrooms',
                'type'     => 'number',
                'title'    => esc_html__('Bathroom', 'swiftcart-core'),
                'default' => 0,
            ),
            array(
                'id'       => 'property_area',
                'type'     => 'text',
                'title'    => esc_html__('Area', 'swiftcart-core'),
                'placeholder' => "1026 sqft",
            ),

        )
    ));
}//endif