<?php
/*
 * Theme Metabox Options
 * @package swiftcart
 * @since 1.0.0
 * */

if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}

if (class_exists('CSF')) {


    /*-------------------------------------
	   Page Options
   -------------------------------------*/
    $swiftcart_group_meta = 'swiftcart_service_meta';
    CSF::createMetabox($swiftcart_group_meta, array(
        'title'     => esc_html__('Service Meta', 'swiftcart-core'),
        'post_type' => 'service',
    ));

    //
    // Create a section
    CSF::createSection($swiftcart_group_meta, array(
        'title'  => esc_html__('Service Info', 'swiftcart-core'),
        'fields' => array(
            array(
                'id'    => 'icon',
                'type'  => 'icon',
                'title' => esc_html__('Service Icon', 'swiftcart-core'),
            ),
            array(
                'id'         => 'features_section_title',
                'title'      => esc_html__('Features Section Title', 'swiftcart-core'),
                'type'       => 'text',
                'default'    => esc_html__('My Experiences', 'swiftcart-core'),
            ),
            array(
                'id'         => 'features',
                'type'       => 'repeater',
                'title'      => esc_html__('Features', 'swiftcart-core'),
                'fields'     => array(
                    array(
                        'id'    => 'icon',
                        'type'  => 'icon',
                        'title' => esc_html__('Icon', 'swiftcart-core'),
                    ),
                    array(
                        'id'    => 'title',
                        'type'  => 'text',
                        'title' => esc_html__('Title', 'swiftcart-core'),
                        'default' => esc_html__('Flexible Solutions', 'swiftcart-core')
                    ),
                    array(
                        'id'    => 'content',
                        'type'  => 'text',
                        'title' => esc_html__('Content', 'swiftcart-core'),
                        'default' => esc_html__('Maecenas tempus, tellus eget condime honcus sem quam semper', 'swiftcart-core')
                    ),
                ),
            ),

        )
    ));

    //
    // FAQ
    CSF::createSection($swiftcart_group_meta, array(
        'title'  => esc_html__('Faq', 'swiftcart-core'),
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__('FAQ', 'swiftcart-core'),
            ),
            array(
                'id'         => 'faq_header',
                'title'      => esc_html__(' FAQ Header', 'swiftcart-core'),
                'type'       => 'text',
                'default'    => esc_html__('More information', 'swiftcart-core'),
            ),
            array(
                'id'         => 'faq_item',
                'type'       => 'repeater',
                'title'      => esc_html__('FAQ', 'swiftcart-core'),
                'fields'     => array(
                    array(
                        'id'    => 'question',
                        'type'  => 'text',
                        'title' => esc_html__('Question', 'swiftcart-core'),
                        'default' => esc_html__('Default Title', 'swiftcart-core')
                    ),
                    array(
                        'id'    => 'answer',
                        'type'  => 'textarea',
                        'title' => esc_html__('Default Answer', 'swiftcart-core'),
                        'default' => esc_html__('Default Answer', 'swiftcart-core')
                    ),

                ),
            ),
            array(
                'id'    => 'image',
                'type'  => 'upload',
                'title' => esc_html__('Image', 'swiftcart-core'),
            ),

        )
    ));
}//endif