<?php
/*
 * Theme Metabox Options
 * @package swiftcart
 * @since 1.0.0
 * */

if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}

if (class_exists('CSF')) {


    /*-------------------------------------
	   Page Options
   -------------------------------------*/
    $swiftcart_group_meta = 'swiftcart_team_meta';
    CSF::createMetabox($swiftcart_group_meta, array(
        'title'     => esc_html__('Team Meta', 'swiftcart-core'),
        'post_type' => 'team',
    ));

    //
    // Create a section
    CSF::createSection($swiftcart_group_meta, array(
        'title'  => esc_html__('Team Member Bio', 'swiftcart-core'),
        'fields' => array(
            array(
                'id'         => 'bio',
                'title'      => esc_html__('Bio', 'swiftcart-core'),
                'type'       => 'text',
                'placeholder'   => esc_html__('Add Bio', 'swiftcart-core'),
                'default'       => esc_html__('Add Bio', 'swiftcart-core'),
            ),
        )
    ));

    //
    // Create a section
    CSF::createSection($swiftcart_group_meta, array(
        'title'  => esc_html__('Social Profile', 'swiftcart-core'),
        'fields' => array(
            array(
                'id'         => 'social_profile',
                'type'       => 'repeater',
                'title'      => esc_html__('Social Profile', 'swiftcart-core'),
                'fields'     => array(
                    array(
                        'id'    => 'icon',
                        'type'  => 'icon',
                        'title' => esc_html__('Pick Up Your Icon', 'swiftcart-core'),
                        'default' => 'fab fa-facebook'
                    ),
                    array(
                        'id'    => 'social_url',
                        'type'  => 'text',
                        'title' => esc_html__('Enter Social Url', 'swiftcart-core'),
                        'default' => esc_html__('#', 'swiftcart-core'),
                    ),
                    array(
                        'id'    => 'color',
                        'type'  => 'color',
                        'title' => esc_html__('Color', 'swiftcart-core'),
                    ),
                ),
            ),
        )
    ));

    //
    // Create a section
    CSF::createSection($swiftcart_group_meta, array(
        'title'  => esc_html__('Images', 'swiftcart-core'),
        'fields' => array(
            array(
                'id'      => 'bg_shape',
                'type'    => 'media',
                'title'   => esc_html__('Background Shape (Layout-One)', 'swiftcart-core'),
                'library' => 'image',
            ),
        )
    ));
}//endif