<?php
/*
 * @package swiftcart-core
 * @since 1.0.0
*/
if (!class_exists('Swiftcart_Post_Type_team')) {
    class Swiftcart_Post_Type_team
    {

        private static $instance;

        /**
         * @var string
         *
         * Set post type params
         */
        private $type               = 'team';
        private $slug               = 'team';
        private $name               = 'team';
        private $singular_name      = 'team';
        private $icon               = 'dashicons-carrot';

        function __construct()
        {

            add_action('init', array($this, 'create_post_type'));
        }

        /**
         * getInstance();
         * @since 1.0.0
         * */
        public static function getInstance()
        {
            if (null == self::$instance) {
                self::$instance = new self();
            }
            return self::$instance;
        }

        function create_post_type()
        {

            $slug = $this->slug;
            $labels = array(
                'name'                  => esc_html_x('Team', 'Post Type General Name', 'swiftcart-core'),
                'singular_name'         => esc_html_x('Tean Sinlge', 'Post Type Singular Name', 'swiftcart-core'),
                'add_new'               => esc_html__('Add New', 'swiftcart-core'),
                'add_new_item'          => esc_html__('Add New ', 'swiftcart-core') . $this->singular_name,
                'edit_item'             => esc_html__('Edit ', 'swiftcart-core') . $this->singular_name,
                'new_item'              => esc_html__('New ', 'swiftcart-core') . $this->singular_name,
                'all_items'             => esc_html__('All ', 'swiftcart-core')  . $this->name,
                'view_item'             => esc_html__('View ', 'swiftcart-core') . $this->singular_name,
                'view_items'            => esc_html__('View ', 'swiftcart-core') . $this->name,
                'search_items'          => esc_html__('Search ', 'swiftcart-core') . $this->name,
                'not_found'             => esc_html__('No ', 'swiftcart-core') . strtolower($this->name) . esc_html__(' found', 'swiftcart-core'),
                'not_found_in_trash'    => esc_html__('No ', 'swiftcart-core') . strtolower($this->name) .  esc_html__(' found in Trash', 'swiftcart-core'),
                'parent_item_colon'     => '',
                'menu_name'             => $this->name,
            );

            $args = array(
                'labels'                => $labels,
                'public'                => true,
                'publicly_queryable'    => true,
                'show_ui'               => true,
                'show_in_menu'          => false,
                'query_var'             => true,
                'rewrite'               => array('slug' => $slug),
                'capability_type'       => 'post',
                'has_archive'           => false,
                'hierarchical'          => true,
                'menu_position'         => 8,
                'supports'              => array('title', 'thumbnail'),
                'yarpp_support'         => true,
                'menu_icon'             => $this->icon,
                'show_in_admin_bar' => true,
            );

            register_post_type($this->type, $args);
        }
    } // end class

    Swiftcart_Post_Type_team::getInstance();
} //endif 