<?php

/**
 * @package SWIFTCART
 * @sicne 1.0.0
 * */

if (!class_exists('Swiftcart_Core_Init')) {

	class Swiftcart_Core_Init {

		//instance
		protected static $instance;

		public function __construct() {
			//plugin_assets
			add_action('wp_enqueue_scripts', array($this, 'plugin_assets'));

			//load plugin dependency files
			$this->load_plugin_dependency_files();
		}

		/**
		 * getInstance()
		 * @since 1.0.0
		 * */
		public static function getInstance() {
			if (null == self::$instance) {
				self::$instance = new self();
			}
			return self::$instance;
		}

		/**
		 * plugin_assets()
		 * @since 1.0.0
		 * */
		public function plugin_assets() {
			$this->load_plugin_css();
			$this->load_plugin_js();
		}


		/**
		 * load plugin css
		 * @since 1.0.0
		 * */
		public function load_plugin_css() {

			// wp_enqueue_style('nice-select', SWIFTCART_CORE_CSS . '/nice-select.min.css', array(), SWIFTCART_CORE_VERSION, 'all');
			wp_enqueue_style('magnific', SWIFTCART_CORE_VERDOR . '/animate/animate.min.css', array(), SWIFTCART_CORE_VERSION, 'all');
			wp_enqueue_style('magnific', SWIFTCART_CORE_VERDOR . '/jquery-magnific-popup/jquery.magnific-popup.css', array(), SWIFTCART_CORE_VERSION, 'all');
			wp_enqueue_style('owl-carousel', SWIFTCART_CORE_VERDOR . '/owl-carousel/css/owl.carousel.min.css', array(), SWIFTCART_CORE_VERSION, 'all');
			wp_enqueue_style('owl-carousel-default', SWIFTCART_CORE_VERDOR . '/owl-carousel/css/owl.theme.default.min.css', array(), SWIFTCART_CORE_VERSION, 'all');


			wp_enqueue_style('slick', SWIFTCART_CORE_CSS . '/slick.css', array(), SWIFTCART_CORE_VERSION, 'all');
		}
		/**
		 * load plugin js
		 * @since 1.0.0
		 * */
		public function load_plugin_js() {


			wp_enqueue_script('bootstrap',  SWIFTCART_CORE_VERDOR . '/bootstrap/js/bootstrap.bundle.min.js', array('jquery'), SWIFTCART_CORE_VERSION, true);
			wp_enqueue_script('wow',  SWIFTCART_CORE_VERDOR . '/wow/wow.js', array('jquery'), SWIFTCART_CORE_VERSION, true);
			wp_enqueue_script('jquery-ui',  SWIFTCART_CORE_VERDOR . '/jquery-ui/jquery-ui.js', array('jquery'), SWIFTCART_CORE_VERSION, true);
			wp_enqueue_script('appear',  SWIFTCART_CORE_VERDOR . '/jquery-appear/jquery.appear.min.js', array('jquery'), SWIFTCART_CORE_VERSION, true);
			wp_enqueue_script('magnific-popup',  SWIFTCART_CORE_VERDOR . '/jquery-magnific-popup/jquery.magnific-popup.min.js', array('jquery'), SWIFTCART_CORE_VERSION, true);
			wp_enqueue_script('validate',  SWIFTCART_CORE_VERDOR . '/jquery-validate/jquery.validate.min.js', array('jquery'), SWIFTCART_CORE_VERSION, true);
			wp_enqueue_script('owl-carousel',  SWIFTCART_CORE_VERDOR . '/owl-carousel/js/owl.carousel.min.js', array('jquery'), SWIFTCART_CORE_VERSION, true);
			wp_enqueue_script('imagesloaded',  SWIFTCART_CORE_VERDOR . '/imagesloaded/imagesloaded.min.js', array('jquery'), SWIFTCART_CORE_VERSION, true);
			wp_enqueue_script('countdown',  SWIFTCART_CORE_VERDOR . '/countdown/countdown.min.js', array('jquery'), SWIFTCART_CORE_VERSION, true);

			// wp_enqueue_script('swiftcart-counter',  SWIFTCART_CORE_JS . '/counter.js', array('jquery'), SWIFTCART_CORE_VERSION, true);
			wp_enqueue_script('swiftcart-elementor-js',  SWIFTCART_CORE_JS . '/elementor-script.js', array('jquery'), SWIFTCART_CORE_VERSION, true);
		}


		/**
		 * load_plugin_dependency_files()
		 * @since 1.0.0
		 * */
		public function load_plugin_dependency_files() {

			$includes_files = array(
				array(
					'file-name' => 'codestar-framework/codestar-framework',
					'file-path' => SWIFTCART_CORE_LIB
				),
				array(
					'file-name' => 'functions',
					'file-path' => SWIFTCART_CORE_INC
				),
				array(
					'file-name' => 'theme-options',
					'file-path' => SWIFTCART_CORE_INC . '/theme-options'
				),
				array(
					'file-name' => 'theme-customizer',
					'file-path' => SWIFTCART_CORE_INC . '/theme-options'
				),
				array(
					'file-name' => 'theme-inline-styles',
					'file-path' => SWIFTCART_CORE_INC . '/theme-stylesheets'
				),
				array(
					'file-name' => 'utility',
					'file-path' => SWIFTCART_CORE_INC
				),
				array(
					'file-name' => 'class-swiftcart-shortcodes',
					'file-path' => SWIFTCART_CORE_SHORTCODES
				),
				array(
					'file-name' => 'class-elementor-widgets-init',
					'file-path' => SWIFTCART_CORE_ELEMENTOR
				),
				array(
					'file-name' => 'class-admin-menu-page',
					'file-path' => SWIFTCART_CORE_ADMIN
				),
				array(
					'file-name' => 'class-header-footer-post-type',
					'file-path' => SWIFTCART_CORE_ADMIN
				),
				array(
					'file-name' => 'metabox/page-metabox',
					'file-path' => SWIFTCART_CORE_ADMIN
				),

				//sidebar widget
				array(
					'file-name' => 'search',
					'file-path' => SWIFTCART_CORE_WIDGETS
				),
				array(
					'file-name' => 'recent-post-widget',
					'file-path' => SWIFTCART_CORE_WIDGETS
				),
				array(
					'file-name' => 'blog-categories-widget',
					'file-path' => SWIFTCART_CORE_WIDGETS
				),
				array(
					'file-name' => 'demo-import',
					'file-path' => SWIFTCART_CORE_INC
				),
			);
			if (is_array($includes_files) && !empty($includes_files)) {
				foreach ($includes_files as  $file) {
					if (file_exists($file['file-path'] . '/' . $file['file-name'] . '.php')) {
						require_once $file['file-path'] . '/' . $file['file-name'] . '.php';
					}
				}
			}
		}
	} //end class

	Swiftcart_Core_Init::getInstance();
}
