<?php
/*
* @packge swiftcart core
* @since 1.0.0
 */
function swiftcart_demo_import() {
  return array(
    array(
      'import_file_name'             => __('Demo', 'swiftcart-core'),
      'page_title'                   => __('Insert Demo', 'swiftcart-core'),
      'local_import_file'            => SWIFTCART_CORE_ROOT_PATH . '/demo/demo-data.xml',
      'local_import_widget_file'     => SWIFTCART_CORE_ROOT_PATH . '/demo/widget.wie',
      'local_import_customizer_file' =>  SWIFTCART_CORE_ROOT_PATH . '/demo/swiftcart-customiser.dat',
      'local_import_json'           => array(
        array(
          'file_path'     =>  SWIFTCART_CORE_ROOT_PATH . '/demo/theme-options.json',
          'option_name'   => 'swiftcart-theme-options',
        ),
      ),
      'import_notice'                => __('This import maybe finish on 5-10 minutes', 'swiftcart-core'),

    ),

  );
}
add_filter('pt-ocdi/import_files', 'swiftcart_demo_import');


if (!function_exists('swiftcart_after_import')) :
  function swiftcart_after_import($selected_import) {
    if ('Demo' === $selected_import['import_file_name']) {

      $main_menu = get_term_by('name', 'Main Menu', 'nav_menu');

      set_theme_mod('nav_menu_locations', array(
        'main-menu' => $main_menu->term_id,
      ));


      //Set Front page
      $page = get_page_by_title('Home One');
      if (isset($page->ID)) {
        update_option('page_on_front', $page->ID);
        update_option('show_on_front', 'page');
      }

      $blog = get_page_by_title('Blog');
      if (isset($page->ID)) {
        update_option('page_for_posts', $blog->ID);
        update_option('show_on_front', 'page');
      }

      //woocommerce
      $woocommerce_shop = get_page_by_title('Swiftcart Shop');
      $woocommerce_checkout = get_page_by_title('Swiftcart Checkout');
      $woocommerce_cart = get_page_by_title('Swiftcart Cart');

      update_option('woocommerce_cart', $woocommerce_cart->ID);
      update_option('woocommerce_checkout_page_id', $woocommerce_checkout->ID);
      update_option('woocommerce_cart_page_id', $woocommerce_cart->ID);
      update_option('woocommerce_shop_page_id', $woocommerce_shop->ID);



      // smart quick view and wishlist
      $woosq_settings = get_option('woosq_settings');

      $woosq_settings['button_type'] = 'button';
      $woosq_settings['button_icon'] = 'only';
      $woosq_settings['button_position'] = '0';

      $woosw_settings = get_option('woosw_settings');

      $woosw_settings['button_type'] = 'button';
      $woosw_settings['button_icon'] = 'only';
      $woosw_settings['button_position_archive'] = '0';
      $woosw_settings['button_position_single'] = '0';

      update_option('woosq_settings', $woosq_settings);
      update_option('woosw_settings', $woosw_settings);
    }
  }
endif;
add_action('pt-ocdi/after_import',  'swiftcart_after_import');

/**
 * Adding local_import_json and import_json param supports.
 */
if (!function_exists('swiftcart_after_content_import_execution')) {
  function swiftcart_after_content_import_execution($selected_import_files, $import_files, $selected_index) {

    $downloader = new OCDI\Downloader();

    if (!empty($import_files[$selected_index]['import_json'])) {

      foreach ($import_files[$selected_index]['import_json'] as $index => $import) {
        $file_path = $downloader->download_file($import['file_url'], 'demo-import-file-' . $index . '-' . date('Y-m-d__H-i-s') . '.json');
        $file_raw  = OCDI\Helpers::data_from_file($file_path);
        update_option($import['option_name'], json_decode($file_raw, true));
      }
    } else if (!empty($import_files[$selected_index]['local_import_json'])) {

      foreach ($import_files[$selected_index]['local_import_json'] as $index => $import) {
        $file_path = $import['file_path'];
        $file_raw  = OCDI\Helpers::data_from_file($file_path);
        update_option($import['option_name'], json_decode($file_raw, true));
      }
    }
  }
  add_action('pt-ocdi/after_content_import_execution', 'swiftcart_after_content_import_execution', 3, 99);
}
