<?php

/**
 * All Elementor widget init
 * @package SWIFTCART
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
	exit(); // exit if access directly
}


if (!class_exists('Swiftcart_Elementor_Widget_Init')) {

	class Swiftcart_Elementor_Widget_Init {
		/*
			* $instance
			* @since 1.0.0
			* */
		private static $instance;
		/*
		* construct()
		* @since 1.0.0
		* */
		public function __construct() {
			add_action('elementor/elements/categories_registered', array($this, '_widget_categories'));
			//elementor widget registered
			add_action('elementor/widgets/widgets_registered', array($this, '_widget_registered'));
			// elementor editor css
			add_filter('elementor/icons_manager/additional_tabs', array($this, 'elementor_custom_icons'));
		}
		/*
	   * getInstance()
	   * @since 1.0.0
	   * */
		public static function getInstance() {
			if (null == self::$instance) {
				self::$instance = new self();
			}
			return self::$instance;
		}
		/**
		 * _widget_categories()
		 * @since 1.0.0
		 * */
		public function _widget_categories($elements_manager) {
			$elements_manager->add_category(
				'swiftcart_widgets',
				[
					'title' => __('Swiftcart Widgets', 'swiftcart-core'),
					'icon' => 'fa fa-plug',
				]
			);
		}

		/**
		 * _widget_registered()
		 * @since 1.0.0
		 * */
		public function _widget_registered() {
			if (!class_exists('Elementor\Widget_Base')) {
				return;
			}
			$elementor_widgets = array(
				'header',
				'slider',
				'offers',
				'banner',
				'info-box',
				'product-list',
				'product-tab',
				'product-category',
				'brand',
				'section-header',
				'imagebox',
				'testimonial',
				'blog',
				'contact-form',
				'about',
				'counter',
				'faq',
				'iconbox',
				'features',
				'news-letter',
				// 'sponsor',
				// 'property',
				// 'service',
				// 'Process',
				// 'video',
				// 'call-to-action',
				// 'pricing',
				// 'gallery',
				// 'tab',
				// 'video',
				// 'team',
				// 'team-details',
				// 'skill',
				// 'service-nav',
				'footer-nav',
				'footer-about',
				// 'footer-subscribe',
				'footer-copyright',
				// 'property-categores',
				// 'footer-gallery',
				// 'property-details',
				// 'footer-top-info',
				// 'footer-contact',
				// 'footer-blog',
				'footer-tag',

				// 'event',

				// 'volunteer',

				// 'portfolio',
				// 'footer-about',
				// 'footer-map',
				// 'portfolio-details',

				// 'event-details',
				// 'funfact',
				// 'how-it-work',
				// 'case-study',
				// 'course',
				// 'copyright',
				// 'preview'
			);
			$elementor_widgets = apply_filters('swiftcart_elementor_widget', $elementor_widgets);

			if (is_array($elementor_widgets) && !empty($elementor_widgets)) {
				foreach ($elementor_widgets as $widget) {
					$widget_file = 'plugins/elementor/widget/' . $widget . '.php';
					$template_file = locate_template($widget_file);
					if (!$template_file || !is_readable($template_file)) {
						$template_file = SWIFTCART_CORE_ELEMENTOR . '/widgets/class-' . $widget . '-widget.php';
					}
					if ($template_file && is_readable($template_file)) {
						include_once $template_file;
					}
				}
			}
		}

		public function elementor_custom_icons($array) {
			return array(
				'swiftcart-icon' => array(
					'name'          => 'swiftcart-icon',
					'label'         => 'Swiftcart Icon',
					'url'           => '',
					'enqueue'       => array(
						SWIFTCART_CORE_VERDOR . '/swiftcart-icons/style.css',
					),
					'prefix'        => '',
					'displayPrefix' => '',
					'labelIcon'     => 'flaticon-magic-wand-1',
					'ver'           => '2.0',
					'fetchJson'     => SWIFTCART_CORE_VERDOR . '/swiftcart-icons/swiftcart-icon.json',
					'native'        => 1,
				),
			);
		}
	}

	if (class_exists('Swiftcart_Elementor_Widget_Init')) {
		Swiftcart_Elementor_Widget_Init::getInstance();
	}
} //end if
