<?php

$this->start_controls_section(
    'layout_two_section_content',
    [
        'label' => esc_html__('Content', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$this->add_control(
    'layout_two_sec_title',
    [
        'label' => esc_html__('Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
        'default' => esc_html__('Add Title', 'swiftcart-core'),
        'label_block' => true,
    ]
);
$this->add_control(
    'layout_two_sec_summary',
    [
        'label' => esc_html__('Summary', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Summary', 'swiftcart-core'),
        'default' => esc_html__('Summary', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_two_button_label',
    [
        'label' => esc_html__('Button Text', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('Descover', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_two_button_url',
    [
        'label' => esc_html__('Button Url', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => esc_html__('#', 'swiftcart-core'),
        'show_external' => true,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);


$this->add_control(
    'layout_two_image',
    [
        'label' => esc_html__('Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);
$this->add_control(
    'layout_two_bg',
    [
        'label' => esc_html__('Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$layout_two_features_list = new \Elementor\Repeater();

$layout_two_features_list->add_control(
    'title',
    [
        'label' => esc_html__('Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
        'default' => esc_html__('Add Title', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_two_features_list',
    [
        'label' => esc_html__('Features List', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_two_features_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
        'default' => [
            [
                'title' => esc_html__('Add List', 'swiftcart-core')
            ],
        ],
    ]
);

$this->end_controls_section();
