<?php /*
* content
*/
$this->start_controls_section(
    'content',
    [
        'label' => esc_html__('Content', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type!' => ['layout_two']
        ]
    ]
);

$this->add_control(
    'bannar_subtitle',
    [
        'label' => esc_html__('Bannar SubTitle', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add SubTitle', 'swiftcart-core'),
        'default' => esc_html__('Add SubTitle', 'swiftcart-core'),
        'condition' => [
            'layout_type' => ['layout_three', 'layout_four', 'layout_five', 'layout_eight', 'layout_nine', 'layout_ten']
        ]
    ]
);
$this->add_control(
    'bannar_title',
    [
        'label' => esc_html__('Bannar Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
        'default' => esc_html__('Add Title', 'swiftcart-core'),
    ]
);

swiftcart_elementor_heading_option($this, 'Section Title', 'h3', 'layout_one');

$this->add_control(
    'bannar_info',
    [
        'label' => esc_html__('Info', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Info Text', 'swiftcart-core'),
        'default' => esc_html__('Add Info Text', 'swiftcart-core'),
        'condition' => [
            'layout_type!' => ['layout_eight', 'layout_nine']
        ]
    ]
);
$this->add_control(
    'bannar_info_two',
    [
        'label' => esc_html__('Info Two', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Info Two Text', 'swiftcart-core'),
        'default' => esc_html__('Add Info Two Text', 'swiftcart-core'),
        'condition' => [
            'layout_type' => ['layout_ten']
        ]
    ]
);

$this->add_control(
    'button_label',
    [
        'label' => esc_html__('Button Text', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('Descover', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$this->add_control(
    'button_url',
    [
        'label' => esc_html__('Button Url', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => esc_html__('#', 'swiftcart-core'),
        'show_external' => true,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);
$this->add_control(
    'button_two_label',
    [
        'label' => esc_html__('Button Two Text', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('Descover', 'swiftcart-core'),
        'label_block' => true,
        'condition' => [
            'layout_type' => ['layout_ten']
        ]
    ]
);

$this->add_control(
    'button_two_url',
    [
        'label' => esc_html__('Buttonc Two Url', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => esc_html__('#', 'swiftcart-core'),
        'show_external' => true,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
        'condition' => [
            'layout_type' => ['layout_ten']
        ]
    ]
);

$this->end_controls_section();

/*
* images
*/
$this->start_controls_section(
    'images',
    [
        'label' => esc_html__('Images', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type!' => ['ggg']
        ]
    ]
);

$this->add_control(
    'banner_image',
    [
        'label' => esc_html__('Banner Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);
$this->add_control(
    'banner_image_author',
    [
        'label' => esc_html__('Author Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
        'condition' => [
            'layout_type' => ['layout_ten']
        ]
    ]
);
$this->add_control(
    'banner_image_two',
    [
        'label' => esc_html__('Banner Image Two', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
        'condition' => [
            'layout_type' => ['layout_six']
        ]
    ]
);
$this->add_control(
    'banner_bg',
    [
        'label' => esc_html__('Banner Image Bg', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
        'condition' => [
            'layout_type' => ['layout_six']
        ]
    ]
);

$this->end_controls_section();
