<?php /*
* content
*/
$this->start_controls_section(
    'layout_three_content',
    [
        'label' => esc_html__('Content', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_three']
        ]
    ]
);

$this->add_control(
    'layout_threebannar_title',
    [
        'label' => esc_html__('Bannar Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
        'default' => esc_html__('Add Title', 'swiftcart-core'),
    ]
);

swiftcart_elementor_heading_option($this, 'Section Title', 'h3', 'layout_three');

$this->add_control(
    'bannar_info',
    [
        'label' => esc_html__('Info', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Info Text', 'swiftcart-core'),
        'default' => esc_html__('Add Info Text', 'swiftcart-core'),
        'condition' => [
            'layout_type' => ['layout_three']
        ]
    ]
);

$this->add_control(
    'button_label',
    [
        'label' => esc_html__('Button Text', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('Descover', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$this->add_control(
    'button_url',
    [
        'label' => esc_html__('Button Url', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => esc_html__('#', 'swiftcart-core'),
        'show_external' => true,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$this->end_controls_section();

/*
* images
*/
$this->start_controls_section(
    'images',
    [
        'label' => esc_html__('Images', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_three']
        ]
    ]
);

$this->add_control(
    'banner_image',
    [
        'label' => esc_html__('Banner Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->end_controls_section();
