<?php /*
* content
*/
$this->start_controls_section(
    'layout_two_content',
    [
        'label' => esc_html__('Content', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_two']
        ]
    ]
);

$this->add_control(
    'layout_two_subtitle',
    [
        'label' => esc_html__('Bannar Sub Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('Add Sub Title', 'swiftcart-core'),
        'default' => esc_html__('Add Sub Title', 'swiftcart-core'),
    ]
);
$this->add_control(
    'layout_two_bannar_title',
    [
        'label' => esc_html__('Bannar Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
        'default' => esc_html__('Add Title', 'swiftcart-core'),
    ]
);

swiftcart_elementor_heading_option($this, 'Section Title', 'h3', 'layout_two');

$this->add_control(
    'layout_two_bannar_info',
    [
        'label' => esc_html__('Info', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Info Text', 'swiftcart-core'),
        'default' => esc_html__('Add Info Text', 'swiftcart-core'),
        'condition' => [
            'layout_type' => ['layout_two']
        ]
    ]
);

$this->add_control(
    'layout_two_button_label',
    [
        'label' => esc_html__('Button Text', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('Descover', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_two_button_url',
    [
        'label' => esc_html__('Button Url', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => esc_html__('#', 'swiftcart-core'),
        'show_external' => true,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$this->add_control(
    'layout_two_bannar_price',
    [
        'label' => esc_html__('Info Price', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Price', 'swiftcart-core'),
        'default' => esc_html__('$590', 'swiftcart-core'),

    ]
);

$this->end_controls_section();

/*
* images
*/
$this->start_controls_section(
    'layout_two_images',
    [
        'label' => esc_html__('Images', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_two']
        ]
    ]
);

$this->add_control(
    'layout_two_banner_image',
    [
        'label' => esc_html__('Banner Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
        ],
    ]
);

$this->end_controls_section();
