<?php

$this->start_controls_section(
    'layout_three_content',
    [
        'label' => esc_html__('Content', 'swiftcart-core'),
        'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'layout_type' => ['layout_three']
        ]
    ]
);

$this->add_control(
    'layout_three_title',
    [
        'label' => esc_html__('Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
        'default' => esc_html__('Add Title', 'swiftcart-core'),

    ]
);
$this->add_control(
    'layout_three_summary',
    [
        'label' => esc_html__('Summary', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Summary', 'swiftcart-core'),
        'default' => esc_html__('Add Summary', 'swiftcart-core'),

    ]
);
$this->add_control(
    'layout_three_button_label',
    [
        'label' => esc_html__('Button Text', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('Descover', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_three_button_url',
    [
        'label' => esc_html__('Button Url', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => esc_html__('#', 'swiftcart-core'),
        'show_external' => true,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'layout_three_sec_content_images',
    [
        'label' => esc_html__('Images', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'layout_type' => 'layout_three'
        ]
    ]
);

$this->add_control(
    'layout_one_img',
    [
        'label' => esc_html__('Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);
$this->add_control(
    'layout_three_bg_image',
    [
        'label' => esc_html__('Background Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->end_controls_section();
