<?php

$this->start_controls_section(
    'counter_section',
    [
        'label' => esc_html__('Features List', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$counter = new \Elementor\Repeater();

$counter->add_control(
    'count',
    [
        'label' => esc_html__('Count Number', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('Count Number ', 'swiftcart-core'),
        'default' => esc_html__('123', 'swiftcart-core'),
        'label_block' => true,
    ]
);
$counter->add_control(
    'units',
    [
        'label' => esc_html__('Count Units', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('Count Number Units', 'swiftcart-core'),
        'default' => esc_html__('m', 'swiftcart-core'),
        'label_block' => true,
    ]
);
$counter->add_control(
    'title',
    [
        'label' => esc_html__('Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
        'default' => esc_html__('Add Title', 'swiftcart-core'),
        'label_block' => true,
    ]
);


$this->add_control(
    'counter_list',
    [
        'label' => esc_html__('Counter List', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $counter->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
        'default' => [
            [
                'title' => esc_html__('Add Title', 'swiftcart-core')
            ],
        ],
    ]
);

$this->end_controls_section();
