<?php
$this->start_controls_section(
    'sec_content',
    [
        'label' => esc_html__('Content', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'layout_type' => ['layout_one', 'layout_two']
        ]
    ]
);

$this->add_control(
    'layout_one_sec_title',
    [
        'label' => __('Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Title', 'swiftcart-core'),
        'default' => esc_html__('Add Title', 'swiftcart-core'),
    ]
);
$this->add_control(
    'layout_one_sec_title_two',
    [
        'label' => __('Title Two', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Title Two', 'swiftcart-core'),
        'default' => esc_html__('Add Title Two', 'swiftcart-core'),
    ]
);

$faq_list_one = new \Elementor\Repeater();

$faq_list_one->add_control(
    'question',
    [
        'label' => esc_html__('Faq Question', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Faq Question', 'swiftcart-core'),
        'default' => esc_html__('Add Question', 'swiftcart-core')
    ]
);

$faq_list_one->add_control(
    'answer',
    [
        'label' => esc_html__('Faq Answer', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Faq Answer', 'swiftcart-core'),
        'default' => esc_html__('Add Answer', 'swiftcart-core')
    ]
);

$this->add_control(
    'layout_one_faq_list',
    [
        'label' => esc_html__('Faq', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $faq_list_one->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ question }}}',
        'default' => [
            [
                'question' => esc_html__('Add Question', 'swiftcart-core')
            ],
        ],
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'contact_content_contact',
    [
        'label' => esc_html__('Contact Form', 'swiftcart-core'),
        'tab'   => \Elementor\Controls_Manager::TAB_CONTENT
    ]
);

$this->add_control(
    'contact_shortcode',
    [
        'label'       => esc_html__('Select your contact form 7', 'swiftcart-core'),
        'label_block' => true,
        'type'        => \Elementor\Controls_Manager::SELECT,
        'options'     => swiftcart_core_post_query('wpcf7_contact_form'),
    ]
);

$this->end_controls_section();
