<?php
$this->start_controls_section(
    'layout_three_sec_content',
    [
        'label' => esc_html__('Content', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'layout_type' => ['layout_three']
        ]
    ]
);

$this->add_control(
    'layout_three_form_title',
    [
        'label' => __('Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Title', 'swiftcart-core'),
        'default' => esc_html__('Add Title', 'swiftcart-core'),
    ]
);

$this->add_control(
    'contact_shortcode',
    [
        'label'       => esc_html__('Select your contact form 7', 'swiftcart-core'),
        'label_block' => true,
        'type'        => \Elementor\Controls_Manager::SELECT,
        'options'     => swiftcart_core_post_query('wpcf7_contact_form'),
    ]
);

$faq_list_three = new \Elementor\Repeater();

$faq_list_three->add_control(
    'question',
    [
        'label' => esc_html__('Faq Question', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Faq Question', 'swiftcart-core'),
        'default' => esc_html__('Add Question', 'swiftcart-core')
    ]
);

$faq_list_three->add_control(
    'answer',
    [
        'label' => esc_html__('Faq Answer', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Faq Answer', 'swiftcart-core'),
        'default' => esc_html__('Add Answer', 'swiftcart-core')
    ]
);

$this->add_control(
    'layout_three_faq_list',
    [
        'label' => esc_html__('Faq', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $faq_list_three->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ question }}}',
        'default' => [
            [
                'question' => esc_html__('Add Question', 'swiftcart-core')
            ],
        ],
    ]
);

$this->end_controls_section();
