<?php

$this->start_controls_section(
    'features_list_section_five',
    [
        'label' => esc_html__('Features List', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'layout_type' => ['layout_five']
        ]
    ]
);

$this->add_control(
    'layout_five_subtitle_icon',
    [
        'label' => esc_html__('Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_five_sec_sub_title',
    [
        'label' => esc_html__('Sec Sub Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
        'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
        'default' => esc_html__('Add Title', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_five_sec_title',
    [
        'label' => esc_html__('Sec Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
        'default' => esc_html__('Add Title', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_five_sec_summary',
    [
        'label' => esc_html__('Sec Summary', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Summary', 'swiftcart-core'),
        'default' => esc_html__('Add Summary', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$layout_five_features_list = new \Elementor\Repeater();

$layout_five_features_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'flaticon-user',
            'library' => 'custom-icon',
        ],
    ]
);

$layout_five_features_list->add_control(
    'title',
    [
        'label' => esc_html__('Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
        'default' => esc_html__('Add Title', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$layout_five_features_list->add_control(
    'summary',
    [
        'label' => esc_html__('Summary', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Summary', 'swiftcart-core'),
        'default' => esc_html__('Add Summary', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_five_features_list',
    [
        'label' => esc_html__('Features List', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_five_features_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
        'default' => [
            [
                'title' => esc_html__('Add Title', 'swiftcart-core')
            ],
        ],
    ]
);


$this->end_controls_section();
