<?php
$this->start_controls_section(
    'features_section',
    [
        'label' => esc_html__('Content', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'layout_type' => 'layout_one'
        ]
    ]
);



$this->add_control(
    'layout_one_sec_title',
    [
        'label' => esc_html__('Sec Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
        'default' => esc_html__('Add Title', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_one_sec_summary',
    [
        'label' => esc_html__('Sec Summary', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Summary', 'swiftcart-core'),
        'default' => esc_html__('Add Summary', 'swiftcart-core'),
        'label_block' => true,
    ]
);


$this->add_control(
    'layout_one_image',
    [
        'label' => esc_html__('Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);
$this->end_controls_section();


$this->start_controls_section(
    'features_list_section',
    [
        'label' => esc_html__('Features List', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$features_list = new \Elementor\Repeater();


$features_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-gps',
            'library' => 'custom-icon',
        ],
    ]
);

$features_list->add_control(
    'title',
    [
        'label' => esc_html__('Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
        'default' => esc_html__('Add Title', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$features_list->add_control(
    'summary',
    [
        'label' => esc_html__('Summary', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Summary', 'swiftcart-core'),
        'default' => esc_html__('Add Summary', 'swiftcart-core'),

    ]
);

$features_list->add_control(
    'bg_color',
    [
        'label' => esc_html__('Bg Color', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
    ]
);

$this->add_control(
    'features_list',
    [
        'label' => esc_html__('Features List', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $features_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
        'default' => [
            [
                'title' => esc_html__('Add Title', 'swiftcart-core')
            ],
        ],
    ]
);

$features_list_two = new \Elementor\Repeater();

$features_list_two->add_control(
    'icon',
    [
        'label' => __('Icon', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-gps',
            'library' => 'custom-icon',
        ],
    ]
);

$features_list_two->add_control(
    'title',
    [
        'label' => esc_html__('Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
        'default' => esc_html__('Add Title', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$features_list_two->add_control(
    'summary',
    [
        'label' => esc_html__('Summary', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Summary', 'swiftcart-core'),
        'default' => esc_html__('Add Summary', 'swiftcart-core'),

    ]
);

$features_list_two->add_control(
    'bg_color',
    [
        'label' => esc_html__('Bg Color', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::COLOR,
    ]
);

$this->add_control(
    'features_list_two',
    [
        'label' => esc_html__('Features List Left', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $features_list_two->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
        'default' => [
            [
                'title' => esc_html__('Add Title', 'swiftcart-core')
            ],
        ],
    ]
);


$this->end_controls_section();
