<?php

$this->start_controls_section(
    'features_list_section_two',
    [
        'label' => esc_html__('Sec Content', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'layout_type' => ['layout_two']
        ]
    ]
);

$this->add_control(
    'layout_two_sec_title',
    [
        'label' => esc_html__('Sec Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
        'default' => esc_html__('Add Title', 'swiftcart-core'),
        'label_block' => true,
    ]
);
$this->add_control(
    'layout_two_sec_summary',
    [
        'label' => esc_html__('Sec Summary', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Summary', 'swiftcart-core'),
        'default' => esc_html__('Add Summary', 'swiftcart-core'),
        'label_block' => true,
    ]
);


$this->add_control(
    'layout_two_image',
    [
        'label' => esc_html__('Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);
$this->end_controls_section();

$this->start_controls_section(
    'features_list_section_feature',
    [
        'label' => esc_html__('Feature List', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'layout_type' => ['layout_two']
        ]
    ]
);

$features_list_layout_two = new \Elementor\Repeater();

$features_list_layout_two->add_control(
    'icon',
    [
        'label' => __('Icon', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-gps',
            'library' => 'custom-icon',
        ],
    ]
);
$features_list_layout_two->add_control(
    'title',
    [
        'label' => esc_html__('Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
        'default' => esc_html__('Add Title', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$this->add_control(
    'features_list_layout_two',
    [
        'label' => esc_html__('Features List', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $features_list_layout_two->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
        'default' => [
            [
                'title' => esc_html__('Add Title', 'swiftcart-core')
            ],
        ],
    ]
);


$this->end_controls_section();

$this->start_controls_section(
    'features_list_section_count',
    [
        'label' => esc_html__('Counter List', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_two']
        ]
    ]
);

$feaure_count_list = new \Elementor\Repeater();

$feaure_count_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-gps',
            'library' => 'custom-icon',
        ],
    ]
);
$feaure_count_list->add_control(
    'count',
    [
        'label' => esc_html__('Count', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Number', 'swiftcart-core'),
        'default' => esc_html__('100', 'swiftcart-core'),
        'label_block' => true,
    ]
);
$feaure_count_list->add_control(
    'title',
    [
        'label' => esc_html__('Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
        'default' => esc_html__('Add Title', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$this->add_control(
    'feaure_count_list',
    [
        'label' => esc_html__('Count List', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $feaure_count_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
        'default' => [
            [
                'title' => esc_html__('Add Title', 'swiftcart-core')
            ],
        ],
    ]
);


$this->end_controls_section();
