<?php

$this->start_controls_section(
    'content_section_one',
    [
        'label' => __('Gallery Content', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'subtitle_shape',
    [
        'label' => esc_html__('Title Shape', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);
$this->add_control(
    'sec_title',
    [
        'label' => __('Section Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'swiftcart-core'),
        'default' => __('Default Title', 'swiftcart-core'),
    ]
);

$this->add_control(
    'sec_sub_title',
    [
        'label' => __('Section Sub Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add sub title', 'swiftcart-core'),
        'default' => __('Default Sub Title', 'swiftcart-core'),
    ]
);
$this->add_control(
    'sec_summary',
    [
        'label' => __('Section Summary', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Summary', 'swiftcart-core'),
        'default' => __('Default Summary', 'swiftcart-core'),
    ]
);

$this->add_control(
    'layout_one_enable_filter',
    [
        'label' => esc_html__('Enable Filter', 'pitoon-addon'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'pitoon-addon'),
        'label_off' => esc_html__('No', 'pitoon-addon'),
        'return_value' => 'yes',
        'default' => 'yes',
    ]
);

$layout_one_projects_filter = new \Elementor\Repeater();

$layout_one_projects_filter->add_control(
    'name',
    [
        'label' => __('Filter Name', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Filter Name', 'swiftcart-core'),
        'default' => __('Default Name', 'swiftcart-core')
    ]
);

$layout_one_projects_filter->add_control(
    'slug',
    [
        'label' => __('Slug', 'slando-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('default-slug', 'slando-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_one_projects_filter',
    [
        'label' => __('Filter', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'prevent_empty' => false,
        'fields' => $layout_one_projects_filter->get_controls(),
        'title_field' => '{{{ name }}}',
        'condition' => [
            'layout_one_enable_filter' => 'yes',
            'layout_type' => 'layout_one'
        ]
    ]
);



$layout_one_projects = new \Elementor\Repeater();

$layout_one_projects->add_control(
    'image',
    [
        'label' => __('Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);
$layout_one_projects->add_control(
    'image_two',
    [
        'label' => __('Image Two', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$layout_one_projects->add_control(
    'slug',
    [
        'label' => __('Slug List', 'slando-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('default-slug', 'slando-addon'),
        'label_block' => true,
    ]
);

$this->add_control(
    'gallery_list_one',
    [
        'label' => __('projects', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_one_projects->get_controls(),
        'prevent_empty' => false,
    ]

);

$this->end_controls_section();
