<?php

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Pricing Content', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_one', 'layout_two', 'layout_four']
        ]
    ]
);

$this->add_control(
    'subtitle_shape',
    [
        'label' => esc_html__('Title Shape', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
        'condition' => [
            'layout_type!' => ['layout_one']
        ]
    ]
);
$this->add_control(
    'sec_title',
    [
        'label' => __('Section Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'swiftcart-core'),
        'default' => __('Default Title', 'swiftcart-core'),
    ]
);

$this->add_control(
    'sec_sub_title',
    [
        'label' => __('Section Sub Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add sub title', 'swiftcart-core'),
        'default' => __('Default Sub Title', 'swiftcart-core'),
    ]
);
$this->add_control(
    'sec_summary',
    [
        'label' => __('Section Summary', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Summary', 'swiftcart-core'),
        'default' => __('Default Summary', 'swiftcart-core'),
    ]
);

$this->add_control(
    'background_image',
    [
        'label' => esc_html__('background Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
        'condition' => [
            'layout_type!' => ['layout_one']
        ]
    ]
);

$this->add_control(
    'pricing_layout_one_pricing_divider',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);

$this->add_control(
    'monthly_heading',
    [
        'label' => __('Monthly Heading', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Monthly Plan', 'swiftcart-core'),
        'default' => __('Monthly Plan', 'swiftcart-core'),
    ]
);

$this->add_control(
    'yearly_heading',
    [
        'label' => __('Annual Plan', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Annual Plan', 'swiftcart-core'),
        'default' => __('Annual Plan', 'swiftcart-core'),
    ]
);

$pricing_monthly_list = new \Elementor\Repeater();

$pricing_monthly_list->add_control(
    'plan_title',
    [
        'label' => __('Plan Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('WEBSITE DESIGN', 'swiftcart-core'),
    ]
);

$pricing_monthly_list->add_control(
    'price',
    [
        'label' => __('Price', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => __('$330', 'swiftcart-core'),
    ]
);

$pricing_monthly_list->add_control(
    'service_list',
    [
        'label' => __('Service List', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::CODE,
        'label_block' => true,
        'default' => wp_kses('<li><i class="flaticon-check"></i>10,000 Monthly Word Limit</li>', 'swiftcart_core_allowed_tags')
    ]
);

$pricing_monthly_list->add_control(
    'button_label',
    [
        'label' => __('Button Label', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Apply Now', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$pricing_monthly_list->add_control(
    'url',
    [
        'label' => __('Url', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'swiftcart-core'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$this->add_control(
    'pricing_monthly_list',
    [
        'label' => __('Monthly List', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $pricing_monthly_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ plan_title }}}',
    ]
);

$this->add_control(
    'pricing_layout_one_divider',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);

$pricing_yearly_list = new \Elementor\Repeater();

$pricing_yearly_list->add_control(
    'plan_title',
    [
        'label' => __('Plan Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Default Plan', 'swiftcart-core'),
        'default' => __('Default Plan', 'swiftcart-core'),
    ]
);

$pricing_yearly_list->add_control(
    'price',
    [
        'label' => __('Price', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => __('$330', 'swiftcart-core'),
    ]
);

$pricing_yearly_list->add_control(
    'service_list',
    [
        'label' => __('Service List', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::CODE,
        'label_block' => true,
        'default' => wp_kses('<li><i class="flaticon-check"></i>10,000 Monthly Word Limit</li>', 'swiftcart_core_allowed_tags')
    ]
);

$pricing_yearly_list->add_control(
    'button_label',
    [
        'label' => __('Button Label', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Purchase Now', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$pricing_yearly_list->add_control(
    'url',
    [
        'label' => __('Url', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'swiftcart-core'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$this->add_control(
    'pricing_yearly_list',
    [
        'label' => __('Yearly List', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $pricing_yearly_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ plan_title }}}',
    ]
);

$this->end_controls_section();
