<?php

$this->start_controls_section(
    'layout_three_content_section',
    [
        'label' => __('Pricing Content', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_three']
        ]
    ]
);

$this->add_control(
    'layout_three_subtitle_shape',
    [
        'label' => esc_html__('Title Shape', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_three_sec_title',
    [
        'label' => __('Section Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'swiftcart-core'),
        'default' => __('Default Title', 'swiftcart-core'),
    ]
);

$this->add_control(
    'layout_three_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add sub title', 'swiftcart-core'),
        'default' => __('Default Sub Title', 'swiftcart-core'),
    ]
);
$this->add_control(
    'layout_three_sec_summary',
    [
        'label' => __('Section Summary', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Summary', 'swiftcart-core'),
        'default' => __('Default Summary', 'swiftcart-core'),
    ]
);

$this->add_control(
    'layout_three_background_image',
    [
        'label' => esc_html__('background Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'pricing_layout_three_pricing_divider',
    [
        'type' => \Elementor\Controls_Manager::DIVIDER,
    ]
);

$pricing_list = new \Elementor\Repeater();

$pricing_list->add_control(
    'plan_title',
    [
        'label' => __('Plan Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'default' => __('WEBSITE DESIGN', 'swiftcart-core'),
    ]
);

$pricing_list->add_control(
    'price',
    [
        'label' => __('Price', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'label_block' => true,
        'default' => __('$330', 'swiftcart-core'),
    ]
);

$pricing_list->add_control(
    'service_list',
    [
        'label' => __('Service List', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::CODE,
        'label_block' => true,
        'default' => wp_kses('<li><i class="flaticon-check"></i>10,000 Monthly Word Limit</li>', 'swiftcart_core_allowed_tags')
    ]
);

$pricing_list->add_control(
    'button_label',
    [
        'label' => __('Button Label', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Apply Now', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$pricing_list->add_control(
    'url',
    [
        'label' => __('Url', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'swiftcart-core'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$this->add_control(
    'layout_three_pricing_list',
    [
        'label' => __('Pricing List', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $pricing_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ plan_title }}}',
    ]
);

$this->end_controls_section();
