<?php

$this->start_controls_section(
    'content_section_heading',
    [
        'label' => __('Section Heading', 'swiftcart-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_one', 'layout_two']
        ]
    ]
);

$this->add_control(
    'sec_title',
    [
        'label' => __('Section Title', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'swiftcart-addon'),
        'default' => __('Default Title', 'swiftcart-addon'),
    ]
);

swiftcart_elementor_heading_option($this, 'Section Title', 'h2', 'layout_one');

$this->add_control(
    'sec_sub_title',
    [
        'label' => __('Section Sub Title', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'swiftcart-addon'),
        'default' => __('Default Sub Title', 'swiftcart-addon'),
    ]
);

swiftcart_elementor_heading_option($this, 'Section Sub Title', 'span', 'layout_one');

$this->add_control(
    'sec_summary',
    [
        'label' => __('summary', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add summary', 'swiftcart-addon'),
        'default' => __('summary', 'swiftcart-addon'),
    ]
);


$this->end_controls_section();

$this->start_controls_section(
    'content_item',
    [
        'label' => esc_html__('Procee Item', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
);

$items = new \Elementor\Repeater();


$items->add_control(
    'number',
    [
        'label' => esc_html__('Number', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '01',
    ]
);

$items->add_control(
    'title',
    [
        'label' => esc_html__('Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('Add title', 'swiftcart-core'),
        'default' => esc_html__('Select a project', 'swiftcart-core')
    ]
);

$items->add_control(
    'text',
    [
        'label' => esc_html__('Text', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Text', 'swiftcart-core'),
        'default' => esc_html__('Vestibulum ante ipsumusn eratultrices posu world', 'swiftcart-core')
    ]
);

$items->add_control(
    'image',
    [
        'label' => esc_html__('Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'items',
    [
        'label' => esc_html__('Items', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $items->get_controls(),
        'prevent_empty' => false,
        'condition' => [
            'layout_type' => ['layout_one', 'layout_two', 'layout_three']
        ],
        'title_field' => '{{{ title }}}',
    ]
);

$this->end_controls_section();
