<?php
$this->start_controls_section(
    'content',
    [
        'label' => esc_html__('Content', 'swiftcart-core'),
        'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'layout_type' => ['layout_one']
        ]
    ]
);

$gallery_list = new \Elementor\Repeater();

$gallery_list->add_control(
    'gallery_photos',
    [
        'label' => esc_html__('Gallery Photos', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);
$this->add_control(
    'gallery_list',
    [
        'label' => esc_html__('Gallery Lists', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $gallery_list->get_controls(),
        'prevent_empty' => false,
    ]
);

$this->end_controls_section();
