<?php
$this->start_controls_section(
    'layout_three_content',
    [
        'label' => esc_html__('Content', 'swiftcart-core'),
        'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'layout_type' => ['layout_three']
        ]
    ]
);


$this->add_control(
    'layout_three_feature_title',
    [
        'label' => esc_html__('Property Feature Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
        'default' => esc_html__('Proparty Attachment', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$layout_three_list = new \Elementor\Repeater();

$layout_three_list->add_control(
    'img',
    [
        'label' => esc_html__('Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);
$layout_three_list->add_control(
    'url',
    [
        'label' => esc_html__('Url', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => esc_html__('#', 'swiftcart-core'),
        'show_external' => true,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$this->add_control(
    'layout_three_list',
    [
        'label' => esc_html__('Download Lists', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_three_list->get_controls(),
        'prevent_empty' => false,
    ]
);

$this->end_controls_section();
