<?php
$this->start_controls_section(
    'layout_two_content',
    [
        'label' => esc_html__('Content', 'swiftcart-core'),
        'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'layout_type' => ['layout_two']
        ]
    ]
);

$this->add_control(
    'layout_two_title',
    [
        'label' => esc_html__('Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
        'default' => esc_html__('Daily Apartment', 'swiftcart-core'),
        'label_block' => true,
    ]
);
$this->add_control(
    'layout_two_summary',
    [
        'label' => esc_html__('Summary', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Summary', 'swiftcart-core'),
        'default' => esc_html__('Summary Text', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_two_feature_title',
    [
        'label' => esc_html__('Property Feature Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
        'default' => esc_html__('Poperty Details', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$layout_two_list = new \Elementor\Repeater();

$layout_two_list->add_control(
    'list',
    [
        'label' => esc_html__('Property Feature Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
        'default' => __('<li>Bedrooms: 3</li>', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_two_list',
    [
        'label' => esc_html__('Property Feature Lists', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_two_list->get_controls(),
        'prevent_empty' => false,
    ]
);

$this->end_controls_section();
