<?php

$this->start_controls_section(
    'content_section_heading',
    [
        'label' => __('Section Heading', 'swiftcart-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_one']
        ]
    ]
);

$this->add_control(
    'sec_title',
    [
        'label' => __('Section Title', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'swiftcart-addon'),
        'default' => __('Default Title', 'swiftcart-addon'),
    ]
);

swiftcart_elementor_heading_option($this, 'Section Title', 'h2', 'layout_one');

$this->add_control(
    'sec_sub_title',
    [
        'label' => __('Section Sub Title', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'swiftcart-addon'),
        'default' => __('Default Sub Title', 'swiftcart-addon'),
    ]
);

swiftcart_elementor_heading_option($this, 'Section Sub Title', 'span', 'layout_one');

$this->add_control(
    'sec_summary',
    [
        'label' => __('summary', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add summary', 'swiftcart-addon'),
        'default' => __('summary', 'swiftcart-addon'),
    ]
);


$this->end_controls_section();

$this->start_controls_section(
    'content_section',
    [
        'label' => __('Service Item', 'swiftcart-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_one']
        ]
    ]
);

$service_list = new \Elementor\Repeater();

$service_list->add_control(
    'title',
    [
        'label' => __('Title', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'swiftcart-addon'),
        'default' => __('Default Title', 'swiftcart-addon'),
    ]
);

swiftcart_elementor_heading_option($service_list, 'Service Title', 'h4', 'layout_one');

$service_list->add_control(
    'summary',
    [
        'label' => __('summary', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add summary', 'swiftcart-addon'),
        'default' => __('summary', 'swiftcart-addon'),
    ]
);

$service_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'flaticon-communication',
            'library' => 'custom-icon',
        ],
    ]
);

$service_list->add_control(
    'url',
    [
        'label' => __('Url', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'swiftcart-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$this->add_control(
    'service_list_one',
    [
        'label' => __('Service Lists', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $service_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->end_controls_section();
