<?php

$this->start_controls_section(
    'content_section_heading_two',
    [
        'label' => __('Section Heading', 'swiftcart-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_two']
        ]
    ]
);

$this->add_control(
    'layout_two_subtitle_shape',
    [
        'label' => esc_html__('Subtitle Shape', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_two_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add sub title', 'swiftcart-addon'),
        'default' => __('Default Sub Title', 'swiftcart-addon'),
    ]
);

$this->add_control(
    'layout_two_sec_title',
    [
        'label' => __('Section Title', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'swiftcart-addon'),
        'default' => __('Default Title', 'swiftcart-addon'),
    ]
);

swiftcart_elementor_heading_option($this, 'Section Title', 'h2', 'layout_two');



$this->add_control(
    'layout_two_sec_summary',
    [
        'label' => __('summary', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add summary', 'swiftcart-addon'),
        'default' => __('summary', 'swiftcart-addon'),
    ]
);

$this->add_control(
    'layout_two_shape_one',
    [
        'label' => esc_html__('Shape One', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);
$this->add_control(
    'layout_two_shape_two',
    [
        'label' => esc_html__('Shape Two', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);
$this->add_control(
    'layout_two_shape_three',
    [
        'label' => esc_html__('Shape Three', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'layout_two_content_section',
    [
        'label' => __('Service Item', 'swiftcart-addon'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_two']
        ]
    ]
);

$layout_two_service_list = new \Elementor\Repeater();



$layout_two_service_list->add_control(
    'title',
    [
        'label' => __('Title', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'swiftcart-addon'),
        'default' => __('Default Title', 'swiftcart-addon'),
    ]
);

$layout_two_service_list->add_control(
    'summary',
    [
        'label' => __('summary', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add summary', 'swiftcart-addon'),
        'default' => __('summary', 'swiftcart-addon'),
    ]
);

$layout_two_service_list->add_control(
    'button_label',
    [
        'label' => __('Button', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Button Text', 'swiftcart-addon'),
        'default' => __('Button Text', 'swiftcart-addon'),
    ]
);

$layout_two_service_list->add_control(
    'url',
    [
        'label' => __('Url', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'swiftcart-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$layout_two_service_list->add_control(
    'image',
    [
        'label' => esc_html__('Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'layout_two_service_list',
    [
        'label' => __('Service Lists', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_two_service_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->end_controls_section();
