<?php /*

* content
*/
$this->start_controls_section(
    'content_nav',
    [
        'label' => esc_html__('Categroy Menu', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_one']
        ]
    ]
);

$this->add_control(
    'nav_menu',
    [
        'label' => __('Select Nav Menu', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::SELECT2,
        'options' => swiftcart_core_nav_menu(),
        'label_block' => true,
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'slider_content',
    [
        'label' => esc_html__('Slider Content', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_one', 'layout_two']
        ]
    ]
);

$slider = new \Elementor\Repeater();


$slider->add_control(
    'image',
    [
        'label' => esc_html__('Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);
$slider->add_control(
    'price',
    [
        'label' => __('Price', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Price', 'swiftcart-addon'),
        'default' => __('$590', 'swiftcart-addon'),
    ]
);
$slider->add_control(
    'subtitle',
    [
        'label' => __('Sub Title', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Sub title', 'swiftcart-addon'),
        'default' => __('Default Sub Title', 'swiftcart-addon'),
    ]
);
$slider->add_control(
    'title',
    [
        'label' => __('Title', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'swiftcart-addon'),
        'default' => __('Default Title', 'swiftcart-addon'),
    ]
);

swiftcart_elementor_heading_option($slider, 'Slider Title', 'h4', 'layout_one');

$slider->add_control(
    'summary',
    [
        'label' => __('summary', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add summary', 'swiftcart-addon'),
        'default' => __('summary', 'swiftcart-addon'),
    ]
);


$slider->add_control(
    'button_label',
    [
        'label' => __('Button Label', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Button Label', 'swiftcart-addon'),
        'default' => __('Button Label', 'swiftcart-addon'),
    ]
);

$slider->add_control(
    'icon',
    [
        'label' => __('Button Icon', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'icon-next',
            'library' => 'custom-icon',
        ],
    ]
);

$slider->add_control(
    'url',
    [
        'label' => __('Url', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'swiftcart-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$this->add_control(
    'slider_list_one',
    [
        'label' => __('Slider Lists', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $slider->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->end_controls_section();
