<?php /*

* content
*/
$this->start_controls_section(
    'layout_three_slider_content',
    [
        'label' => esc_html__('Slider Content', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_three']
        ]
    ]
);

$slider_three = new \Elementor\Repeater();


$slider_three->add_control(
    'image',
    [
        'label' => esc_html__('Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$slider_three->add_control(
    'subtitle',
    [
        'label' => __('Sub Title', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Sub title', 'swiftcart-addon'),
        'default' => __('Default Sub Title', 'swiftcart-addon'),
    ]
);
$slider_three->add_control(
    'title',
    [
        'label' => __('Title', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add title', 'swiftcart-addon'),
        'default' => __('Default Title', 'swiftcart-addon'),
    ]
);

swiftcart_elementor_heading_option($slider_three, 'Slider Title', 'h4', 'layout_three');

$slider_three->add_control(
    'big_title',
    [
        'label' => __('Big Title', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Big Title', 'swiftcart-addon'),
        'default' => __('Big Title', 'swiftcart-addon'),
    ]
);


$slider_three->add_control(
    'button_label',
    [
        'label' => __('Button Label', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Button Label', 'swiftcart-addon'),
        'default' => __('Button Label', 'swiftcart-addon'),
    ]
);

$slider_three->add_control(
    'url',
    [
        'label' => __('Url', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('#', 'swiftcart-addon'),
        'show_external' => false,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => true,
    ]
);

$this->add_control(
    'slider_list_three',
    [
        'label' => __('Slider Lists', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $slider_three->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->end_controls_section();
