<?php

$this->start_controls_section(
    'content_section_one',
    [
        'label' => __('Content', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'subtitle_shape',
    [
        'label' => esc_html__('Title Shape', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);
$this->add_control(
    'sec_title',
    [
        'label' => __('Section Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'swiftcart-core'),
        'default' => __('Default Title', 'swiftcart-core'),
    ]
);

$this->add_control(
    'sec_sub_title',
    [
        'label' => __('Section Sub Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add sub title', 'swiftcart-core'),
        'default' => __('Default Sub Title', 'swiftcart-core'),
    ]
);
$this->add_control(
    'sec_summary',
    [
        'label' => __('Section Summary', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Summary', 'swiftcart-core'),
        'default' => __('Default Summary', 'swiftcart-core'),
    ]
);

$this->add_control(
    'layout_one_shape',
    [
        'label' => __('Shape', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
        ],
    ]
);

$layout_one_projects_filter = new \Elementor\Repeater();

$layout_one_projects_filter->add_control(
    'name',
    [
        'label' => __('Tab Name', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Tab Name', 'swiftcart-core'),
        'default' => __('Default Name', 'swiftcart-core')
    ]
);

$this->add_control(
    'layout_one_projects_filter',
    [
        'label' => __('Tab', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'prevent_empty' => false,
        'fields' => $layout_one_projects_filter->get_controls(),
        'title_field' => '{{{ name }}}',
    ]
);



$layout_one_projects = new \Elementor\Repeater();

$layout_one_projects->add_control(
    'title',
    [
        'label' => __('title', 'slando-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('title', 'slando-addon'),
        'label_block' => true,
    ]
);

$layout_one_projects->add_control(
    'info',
    [
        'label' => __('Info', 'slando-addon'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'default' => __('Info', 'slando-addon'),
        'label_block' => true,
    ]
);

$layout_one_projects->add_control(
    'name',
    [
        'label' => __('Name', 'slando-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Name', 'slando-addon'),
        'label_block' => true,
    ]
);
$layout_one_projects->add_control(
    'bio',
    [
        'label' => __('Bio', 'slando-addon'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => __('Bio', 'slando-addon'),
        'label_block' => true,
    ]
);

$layout_one_projects->add_control(
    'button_label',
    [
        'label' => esc_html__('Button Text', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('Descover', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$layout_one_projects->add_control(
    'button_url',
    [
        'label' => esc_html__('Button Url', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => esc_html__('#', 'swiftcart-core'),
        'show_external' => true,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$layout_one_projects->add_control(
    'avata',
    [
        'label' => __('Avata', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);
$layout_one_projects->add_control(
    'image',
    [
        'label' => __('Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);
$this->add_control(
    'tab_list_one',
    [
        'label' => __('Tab Content', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_one_projects->get_controls(),
        'prevent_empty' => false,
    ]

);

$this->end_controls_section();
