<?php

$this->start_controls_section(
    'content_section_two',
    [
        'label' => __('Content', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => 'layout_two'
        ]
    ]
);

$this->add_control(
    'layout_two_subtitle_shape',
    [
        'label' => esc_html__('Title Shape', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);
$this->add_control(
    'layout_two_sec_title',
    [
        'label' => __('Section Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add title', 'swiftcart-core'),
        'default' => __('Default Title', 'swiftcart-core'),
    ]
);

$this->add_control(
    'layout_two_sec_sub_title',
    [
        'label' => __('Section Sub Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add sub title', 'swiftcart-core'),
        'default' => __('Default Sub Title', 'swiftcart-core'),
    ]
);
$this->add_control(
    'layout_two_sec_summary',
    [
        'label' => __('Section Summary', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'rows' => '2',
        'placeholder' => __('Add Summary', 'swiftcart-core'),
        'default' => __('Default Summary', 'swiftcart-core'),
    ]
);

$this->add_control(
    'layout_two_shape',
    [
        'label' => __('Shape', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);
$this->add_control(
    'layout_two_shape_two',
    [
        'label' => __('Shape Two', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$layout_two_projects = new \Elementor\Repeater();

$layout_two_projects->add_control(
    'name',
    [
        'label' => __('Tab Name', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => __('Add Tab Name', 'swiftcart-core'),
        'default' => __('Default Name', 'swiftcart-core')
    ]
);

$layout_two_projects->add_control(
    'image',
    [
        'label' => __('Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);
$this->add_control(
    'layout_two_tab_list',
    [
        'label' => __('Tab Content', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_two_projects->get_controls(),
        'prevent_empty' => false,
    ]

);

$this->end_controls_section();
