<?php

$this->start_controls_section(
    'section_content',
    [
        'label' => esc_html__('Content', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'layout_type' => 'layout_one'
        ]
    ]
);



$this->add_control(
    'layout_one_sec_subtitle',
    [
        'label' => esc_html__('Bio', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Sub Title', 'swiftcart-core'),
        'default' => esc_html__('Add Sub Title', 'swiftcart-core'),
        'label_block' => true,
    ]
);
$this->add_control(
    'layout_one_sec_title',
    [
        'label' => esc_html__('Name', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Name', 'swiftcart-core'),
        'default' => esc_html__('Add Name', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_one_sec_summary',
    [
        'label' => esc_html__('Summary', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Summary', 'swiftcart-core'),
        'default' => esc_html__('Add Summary', 'swiftcart-core'),
        'label_block' => true,
    ]
);
$this->add_control(
    'layout_one_sec_summary_two',
    [
        'label' => esc_html__('Summary Two', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Summary Two', 'swiftcart-core'),
        'default' => esc_html__('Add Summary Two', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$social_list = new \Elementor\Repeater();

$social_list->add_control(
    'icon',
    [
        'label' => __('Icon', 'swiftcart-addon'),
        'type' => \Elementor\Controls_Manager::ICONS,
        'default' => [
            'value' => 'flaticon-communication',
            'library' => 'custom-icon',
        ],
    ]
);

$social_list->add_control(
    'url',
    [
        'label' => esc_html__('Url', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => esc_html__('#', 'swiftcart-core'),
        'show_external' => true,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$this->add_control(
    'social_list',
    [
        'label' => esc_html__('Social List', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $social_list->get_controls(),
        'prevent_empty' => false,
    ]
);

$this->end_controls_section();


$this->start_controls_section(
    'section_image',
    [
        'label' => esc_html__('Imaege', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'layout_one_img',
    [
        'label' => esc_html__('Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->end_controls_section();
