<?php
/*
* content
*/
$this->start_controls_section(
    'content',
    [
        'label' => esc_html__('Content', 'swiftcart-core'),
        'condition' => [
            'layout_type' => ['layout_one']
        ]
    ]
);

$team_list = new \Elementor\Repeater();

$team_list->add_control(
    'name',
    [
        'label' => esc_html__('Name', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('Add Name', 'swiftcart-core'),
        'default' => esc_html__('Add Name', 'swiftcart-core'),
        'label_block' => true,

    ]
);

$team_list->add_control(
    'url',
    [
        'label' => esc_html__('Url', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => esc_html__('#', 'swiftcart-core'),
        'show_external' => true,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$team_list->add_control(
    'bio',
    [
        'label' => esc_html__('Bio', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('Add Bio', 'swiftcart-core'),
        'default' => esc_html__('Add Bio', 'swiftcart-core'),
        'label_block' => true,

    ]
);
$team_list->add_control(
    'social',
    [
        'label' => esc_html__('Social', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::CODE,
        'placeholder' => esc_html__('Add Social', 'swiftcart-core'),
        'default' => wp_kses('<li><a href="#"><i class="fab fa-facebook-f"></i></a></li>', 'swiftcart_core_allowed_tags'),
        'label_block' => true,

    ]
);




$team_list->add_control(
    'image',
    [
        'label' => __('Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'team_list',
    [
        'label' => esc_html__('Testimonial Lists', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $team_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ name }}}',
        'default' => [
            [
                'name' => esc_html__('Add Name', 'swiftcart-core')
            ],
        ],
    ]
);


$this->end_controls_section();
