<?php
/*
* content
*/
$this->start_controls_section(
    'content',
    [
        'label' => esc_html__('Content', 'swiftcart-core'),
        'condition' => [
            'layout_type' => ['layout_one', 'layout_two']
        ]
    ]
);

$testimonial_list = new \Elementor\Repeater();

$testimonial_list->add_control(
    'name',
    [
        'label' => esc_html__('Name', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('Add Name', 'swiftcart-core'),
        'default' => esc_html__('Add Name', 'swiftcart-core'),
        'label_block' => true,

    ]
);

$testimonial_list->add_control(
    'bio',
    [
        'label' => esc_html__('Bio', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('Add Bio', 'swiftcart-core'),
        'default' => esc_html__('Add Bio', 'swiftcart-core'),
        'label_block' => true,

    ]
);


$testimonial_list->add_control(
    'image',
    [
        'label' => __('Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);
$testimonial_list->add_control(
    'quote',
    [
        'label' => __('Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$testimonial_list->add_control(
    'testimonial_content',
    [
        'label' => esc_html__('Testimonial Content', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Testimonial Content', 'swiftcart-core'),
        'default' => esc_html__('Add Testimonial Content', 'swiftcart-core'),
    ]
);

$testimonial_list->add_control(
    'rating',
    [
        'label' => __('Ratting', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['count'],
        'range' => [
            'count' => [
                'min' => 1,
                'max' => 5,
                'step' => 1,
            ],
        ],
        'default' => [
            'unit' => 'count',
            'size' => 5,
        ],
    ]
);

$this->add_control(
    'testimonial_list',
    [
        'label' => esc_html__('Testimonial Lists', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $testimonial_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ name }}}',
        'default' => [
            [
                'name' => esc_html__('Add Name', 'swiftcart-core')
            ],
        ],
    ]
);


$this->end_controls_section();


/*
		* Images
		*/
$this->start_controls_section(
    'images',
    [
        'label' => esc_html__('Images', 'swiftcart-core'),
        'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_one', 'layout_two']
        ]
    ]
);

$this->add_control(
    'bg_image',
    [
        'label' => __('Background Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],

    ]
);


$this->end_controls_section();
