<?php
/*
* content
*/
$this->start_controls_section(
    'content_three',
    [
        'label' => esc_html__('Content', 'swiftcart-core'),
        'condition' => [
            'layout_type' => ['layout_three']
        ]
    ]
);

$this->add_control(
    'layout_three_title',
    [
        'label' => __('Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Title', 'swiftcart-core'),
        'default' => esc_html__('Add Title', 'swiftcart-core'),

    ]
);

$this->add_control(
    'layout_three_summary',
    [
        'label' => __('Summary', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => __('Add Summary', 'swiftcart-core'),
        'default' => esc_html__('Add Summary', 'swiftcart-core'),
    ]
);

$testimonial_list_three = new \Elementor\Repeater();

$testimonial_list_three->add_control(
    'name',
    [
        'label' => esc_html__('Name', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('Add Name', 'swiftcart-core'),
        'default' => esc_html__('Add Name', 'swiftcart-core'),
        'label_block' => true,

    ]
);

$testimonial_list_three->add_control(
    'bio',
    [
        'label' => esc_html__('Bio', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('Bio', 'swiftcart-core'),
        'default' => esc_html__('Bio', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$testimonial_list_three->add_control(
    'testimonial_content',
    [
        'label' => esc_html__('Testimonial Content', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Testimonial Content', 'swiftcart-core'),
        'default' => esc_html__('Add Testimonial Content', 'swiftcart-core'),
    ]
);

$testimonial_list_three->add_control(
    'img',
    [
        'label' => esc_html__('Author Img', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$testimonial_list_three->add_control(
    'rating',
    [
        'label' => __('Ratting', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['count'],
        'range' => [
            'count' => [
                'min' => 1,
                'max' => 5,
                'step' => 1,
            ],
        ],
        'default' => [
            'unit' => 'count',
            'size' => 5,
        ],
    ]
);


$this->add_control(
    'layout_three_testimonial_list',
    [
        'label' => esc_html__('Testimonial Lists', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $testimonial_list_three->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ name }}}',
        'default' => [
            [
                'name' => esc_html__('Add Name', 'swiftcart-core')
            ],
        ],

    ]
);


$this->end_controls_section();


/*
		* Images
		*/
$this->start_controls_section(
    'layout_three_images',
    [
        'label' => esc_html__('Images', 'swiftcart-core'),
        'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition' => [
            'layout_type' => ['layout_three']
        ]
    ]
);

$this->add_control(
    'layout_three_bg_image',
    [
        'label' => __('Background Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->end_controls_section();
