<?php

$this->start_controls_section(
    'layout_four_content',
    [
        'label' => esc_html__('Content', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'layout_type' => 'layout_four'
        ]
    ]
);

$this->add_control(
    'layout_four_subtitle_shape',
    [
        'label' => esc_html__('subtitle Shape', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_four_subtitle',
    [
        'label' => esc_html__('Sub Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Sub Title', 'swiftcart-core'),
        'default' => esc_html__('Add Sub Title', 'swiftcart-core'),
    ]
);
$this->add_control(
    'layout_four_title',
    [
        'label' => esc_html__('Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
        'default' => esc_html__('Add Title', 'swiftcart-core'),
    ]
);
$this->add_control(
    'layout_four_summary',
    [
        'label' => esc_html__('Summary', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::CODE,
        'placeholder' => esc_html__('Add Summary', 'swiftcart-core'),
        'default' => esc_html__('Automatic closed captions included', 'swiftcart-core'),
    ]
);

$this->add_control(
    'layout_four_shape_one',
    [
        'label' => esc_html__('Background Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);
$this->add_control(
    'layout_four_shape_two',
    [
        'label' => esc_html__('Background Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_four_shape_three',
    [
        'label' => esc_html__('Background Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$layout_four_list = new \Elementor\Repeater();


$layout_four_list->add_control(
    'title',
    [
        'label' => esc_html__('Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Title', 'swiftcart-core'),
        'default' => 'Title',
        'label_block' => true
    ]
);

$layout_four_list->add_control(
    'summary',
    [
        'label' => esc_html__('Summary', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('Summary', 'swiftcart-core'),
        'default' => 'Summary',
        'label_block' => true
    ]
);
$layout_four_list->add_control(
    'button_label',
    [
        'label' => esc_html__('Button Text', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('Descover', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$layout_four_list->add_control(
    'url',
    [
        'label' => esc_html__('Button Url', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => esc_html__('#', 'swiftcart-core'),
        'show_external' => true,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$layout_four_list->add_control(
    'image',
    [
        'label' => __('Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'layout_four_list',
    [
        'label' => esc_html__('Video Tab', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_four_list->get_controls(),
        'prevent_empty' => false,
    ]
);

$this->end_controls_section();
