<?php

$this->start_controls_section(
    'content',
    [
        'label' => esc_html__('Content', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'layout_type' => 'layout_one'
        ]
    ]
);

$this->add_control(
    'layout_one_subtitle',
    [
        'label' => esc_html__('Sub Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Sub Title', 'swiftcart-core'),
        'default' => esc_html__('Add Sub Title', 'swiftcart-core'),
    ]
);
$this->add_control(
    'layout_one_title',
    [
        'label' => esc_html__('Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
        'default' => esc_html__('Add Title', 'swiftcart-core'),
    ]
);
$this->add_control(
    'layout_one_summary',
    [
        'label' => esc_html__('Summary', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Summary', 'swiftcart-core'),
        'default' => esc_html__('Add Summary', 'swiftcart-core'),
    ]
);

$this->add_control(
    'layout_one_video_url',
    [
        'label' => esc_html__('Video Url', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('Add Video Url', 'swiftcart-core'),
        'default' => 'https://www.youtube.com/watch?v=o_MjdUtSL7g',
        'label_block' => true
    ]
);


$this->add_control(
    'layout_one_img',
    [
        'label' => esc_html__('Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);


$layout_one_list = new \Elementor\Repeater();

$layout_one_list->add_control(
    'title',
    [
        'label' => esc_html__('Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add title', 'swiftcart-core'),
        'default' => esc_html__('Experiences', 'swiftcart-core')
    ]
);

$this->add_control(
    'layout_one_list',
    [
        'label' => esc_html__('Fun Fact', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_one_list->get_controls(),
        'prevent_empty' => false,
        'title_field' => '{{{ title }}}',
    ]
);

$this->end_controls_section();
