<?php

$this->start_controls_section(
    'layout_three_content',
    [
        'label' => esc_html__('Content', 'swiftcart-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'layout_type' => 'layout_three'
        ]
    ]
);

$this->add_control(
    'layout_three_subtitle_shape',
    [
        'label' => esc_html__('Subtitle Shape', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$this->add_control(
    'layout_three_subtitle',
    [
        'label' => esc_html__('Sub Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Sub Title', 'swiftcart-core'),
        'default' => esc_html__('Add Sub Title', 'swiftcart-core'),
    ]
);
$this->add_control(
    'layout_three_title',
    [
        'label' => esc_html__('Title', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXTAREA,
        'placeholder' => esc_html__('Add Title', 'swiftcart-core'),
        'default' => esc_html__('Add Title', 'swiftcart-core'),
    ]
);
$this->add_control(
    'layout_three_summary',
    [
        'label' => esc_html__('Summary', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::CODE,
        'placeholder' => esc_html__('Add Summary', 'swiftcart-core'),
        'default' => esc_html__('Automatic closed captions included', 'swiftcart-core'),
    ]
);

$this->add_control(
    'layout_three_button_label',
    [
        'label' => esc_html__('Button Text', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => esc_html__('Descover', 'swiftcart-core'),
        'label_block' => true,
    ]
);

$this->add_control(
    'layout_three_button_url',
    [
        'label' => esc_html__('Button Url', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => esc_html__('#', 'swiftcart-core'),
        'show_external' => true,
        'default' => [
            'url' => '#',
            'is_external' => false,
            'nofollow' => false,
        ],
        'show_label' => false,
    ]
);

$this->add_control(
    'layout_three_bg',
    [
        'label' => esc_html__('Background Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);

$layout_three_list = new \Elementor\Repeater();

$layout_three_list->add_control(
    'flag',
    [
        'label' => __('Flag', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [],
    ]
);
$layout_three_list->add_control(
    'tab',
    [
        'label' => esc_html__('Tab', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('Tab', 'swiftcart-core'),
        'default' => 'Tab',
        'label_block' => true
    ]
);
$layout_three_list->add_control(
    'video_url',
    [
        'label' => esc_html__('Video Url', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::TEXT,
        'placeholder' => esc_html__('Add Video Url', 'swiftcart-core'),
        'default' => 'https://www.youtube.com/watch?v=o_MjdUtSL7g',
        'label_block' => true
    ]
);

$layout_three_list->add_control(
    'image',
    [
        'label' => __('Image', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
    ]
);

$this->add_control(
    'layout_three_list',
    [
        'label' => esc_html__('Video Tab', 'swiftcart-core'),
        'type' => \Elementor\Controls_Manager::REPEATER,
        'fields' => $layout_three_list->get_controls(),
        'prevent_empty' => false,
    ]
);

$this->end_controls_section();
