<?php if ('layout_four' == $settings['layout_type']) : ?>

    <!-- Counter area start -->
    <div class="counter-area pt-110 rpt-115 pb-90 bgs-cover rel z-1" style="background-image: url(<?php echo esc_url($settings['layout_four_bg_image']['url']); ?>);">
        <div class="container">
            <div class="row justify-content-end">
                <div class="col-xl-8 col-lg-10">
                    <div class="counter-section-content">
                        <div class="section-title">
                            <?php if (!empty($settings['about_four_title'])) : ?>
                                <h2><?php echo esc_html($settings['about_four_title']); ?></h2>
                            <?php endif; ?>
                        </div>
                        <?php if (!empty($settings['about_four_summary'])) : ?>
                            <i class="about-four-summary"><?php echo wp_kses($settings['about_four_summary'], 'swiftcart_core_allowed_tags'); ?></i>
                        <?php endif; ?>
                        <div class="counter-btns mb-100">
                            <?php if (!empty($settings['button_one_label'])) : ?>
                                <a class="btn" href="<?php echo esc_url($settings['button_one_url']['url']); ?>"><?php echo esc_html($settings['button_one_label']); ?></a>
                            <?php endif; ?>
                            <?php if (!empty($settings['button_two_label'])) : ?>
                                <a class="btn btn--yellow" href="<?php echo esc_url($settings['button_two_url']['url']); ?>"><?php echo esc_html($settings['button_two_label']); ?></a>
                            <?php endif; ?>
                        </div>
                        <?php if (is_array($settings['counter_layout_four'])) : ?>
                            <div class="row">
                                <?php foreach ($settings['counter_layout_four'] as $item) : ?>
                                    <div class="col-md-4 col-sm-6">
                                        <div class="counter-item counter-text-wrap">
                                            <div class="counter-item__icon" style="background-image: url(<?php echo esc_url($item['counter_icon_shape']['url']); ?>);"><i class="<?php echo esc_attr($item['icon']['value']); ?>"></i></div>
                                            <div class="counter-item__content">
                                                <span class="count-text" data-speed="3000" data-stop="<?php echo esc_attr($item['number']); ?>">0</span>
                                                <h5 class="counter-title"><?php echo esc_html($item['info']); ?></h5>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Counter area end -->

<?php endif; ?>