<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!-- about one start -->
    <div class="sw-about-one pt-80 pb-80">
        <div class="container">
            <div class="row gutter-y-30 align-items-center">
                <div class="col-xl-6 col-xxl-7">
                    <div class="sw-about-one__left">
                        <?php if (!empty($settings['layout_one_img']['url'])): ?>
                            <div class="sw-about-one__img">
                                <?php swiftcart_elementor_rendered_image($settings, 'layout_one_img'); ?>
                            </div>
                        <?php endif; ?>
                        <div class="sw-about-one__img-2">
                            <?php swiftcart_elementor_rendered_image($settings, 'layout_one_img_two'); ?>
                            <?php swiftcart_elementor_rendered_image($settings, 'layout_one_img_three'); ?>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-xxl-5">
                    <div class="sw-about-one__right">
                        <div class="sw-about-one__heading">
                            <?php if (!empty($settings['layout_one_sec_subtitle'])) : ?>
                                <span class="sw-about-one__subtitle"><?php echo esc_html($settings['layout_one_sec_subtitle']); ?></span>
                            <?php endif; ?>
                            <?php if (!empty($settings['layout_one_sec_title'])) : ?>
                                <h3 class="sw-about-one__title"><?php echo wp_kses($settings['layout_one_sec_title'], 'swiftcart_core_allowed_tags');  ?></h3>
                            <?php endif; ?>
                            <?php if (!empty($settings['layout_one_sec_summary'])) : ?>
                                <p class="sw-about-one__info"><?php echo wp_kses($settings['layout_one_sec_summary'], 'swiftcart_core_allowed_tags');  ?></p>
                            <?php endif; ?>
                        </div>
                        <ul class="sw-about-one__checklist">
                            <?php if (is_array($settings['features_list'])) : ?>
                                <?php foreach ($settings['features_list'] as $item) : ?>
                                    <li><?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'i'); ?>
                                        <?php if (!empty($item['title'])) : ?>
                                            <?php echo wp_kses($item['title'], 'swiftcart_core_allowed_tags'); ?>
                                        <?php endif; ?>
                                    </li>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </ul>
                        <?php if (!empty($settings['button_label'])) : ?>
                            <a class="swiftcart-btn" <?php esc_attr(!empty($settings['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['button_url']['url']); ?>"><?php echo esc_html($settings['button_label']); ?></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- about one end -->

<?php endif; ?>