<?php if ('layout_two' == $settings['layout_type']) : ?>
    <!--======  Start Hero Section  ======-->
    <section class="hero-section">
        <div class="hero-wrapper-three bg_cover" style="background-image: url(<?php echo esc_url($settings['layout_two_bg']['url']) ?>);">
            <div class="container">
                <div class="row">
                    <div class="col-xl-5">
                        <!--===  Hero Content  ===-->
                        <div class="hero-content mb-50 pt-15">
                            <?php if (!empty($settings['layout_two_sec_title'])) : ?>
                                <h1 class="heading-title wow fadeInDown"><?php echo wp_kses($settings['layout_two_sec_title'], 'swiftcart_core_allowed_tags');  ?></h1>
                            <?php endif; ?>
                            <?php if (!empty($settings['layout_two_sec_summary'])) : ?>
                                <p class="wow fadeInUp"><?php echo wp_kses($settings['layout_two_sec_summary'], 'swiftcart_core_allowed_tags');  ?></p>
                            <?php endif; ?>
                            <ul class="circle-list style-one mb-65 wow fadeInDown ml-0">
                                <?php if (is_array($settings['layout_two_features_list'])) : ?>
                                    <?php foreach ($settings['layout_two_features_list'] as $item) : ?>
                                        <li><?php echo esc_html($item['title']) ?></li>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </ul>
                            <div class="hero-button wow fadeInUp">
                                <?php if (!empty($settings['layout_two_button_label'])) : ?>
                                    <a class="theme-btn style-one" <?php esc_attr(!empty($settings['layout_two_button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['layout_two_button_url']['url']); ?>"><?php echo esc_html($settings['layout_two_button_label']); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-7">
                        <!--===  Hero Image  ===-->
                        <div class="hero-one_image-box wow fadeInRight swiftcart-tilt" data-tilt-options='{ "glare": false, "maxGlare": 0, "maxTilt": 5, "speed": 700, "scale": 1 }'>
                            <?php swiftcart_elementor_rendered_image($settings, 'layout_two_image'); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section><!--======  End Hero Section  ======-->
<?php endif; ?>