<?php if ('layout_six' == $settings['layout_type']) : ?>
    <div class="sw-banner-six">
        <div class="container">
            <div class="sw-banner-six__wrapper sw-include-bg" data-bg="<?php echo esc_url($settings['banner_bg']['url']); ?>">
                <div class="sw-banner-six__content">
                    <?php if (!empty($settings['bannar_title'])) :
                        $this->add_inline_editing_attributes('bannar_title', 'none');
                        swiftcart_elementor_rendered_content($this, 'bannar_title', 'sw-banner-six__title', $settings['section_title_tag_layout_one']);
                    endif;
                    ?>
                    <p class="sw-banner-six__info"><?php echo wp_kses($settings['bannar_info'], 'swiftcart_core_allowed_tags');  ?></p>
                </div>
                <?php if (!empty($settings['button_label'])) : ?>
                    <div class="sw-banner-six__btn">
                        <a class="swiftcart-btn" <?php esc_attr(!empty($settings['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['button_url']['url']); ?>"><?php echo esc_html($settings['button_label']); ?></a>
                    </div>
                <?php endif; ?>
                <div class="sw-banner-six__imgs">
                    <div class="sw-banner-six__img-1">
                        <?php swiftcart_elementor_rendered_image($settings, 'banner_image'); ?>
                    </div>
                    <div class="sw-banner-six__img-2">
                        <?php swiftcart_elementor_rendered_image($settings, 'banner_image_two'); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- banner six end -->
<?php endif; ?>